
// win_gzip.c

#include <config.h>
#include <system.h>
#include <common.h>

#ifdef _MSC_VER
static char _s_zipbuf[264];
static char _s_outbuf[264];
static char _s_arcbuf[264];
static char _s_cwdbuf[264];
static struct stat _s_sbuf;

void try_to_gzip_it( void )
{
  char * zb = _s_zipbuf;
  char * ob = _s_outbuf;
  const char * arcname = archive_name_array[0];
  int res;
  if( arcname && *arcname )
  {
     sprintf(zb, "gzip %s", arcname );
     res = system(zb);
     if(res) {
        sprintf(ob, "ERROR: CMD: [%s] returned %d (errno=%d)!\n"
           "gzip may not be in PATH?\n", zb, res, errno );
        fprintf(stderr,ob);
     } else {
        strcpy(zb, arcname );
        strcat(zb, ".gz" );
        if( stat( zb, &_s_sbuf ) != 0 )
        {
           sprintf(ob, "WARNING: gzip failed, as file [%s] does not seem to exist!\n", zb );
           fprintf(stderr,ob);
        }
     }
  }
}

int try_to_ungzip_it( int ro )
{
  char * zb = _s_zipbuf;
  char * ob = _s_outbuf;
  char * ab = _s_arcbuf;
  char * cwd = _s_cwdbuf; /* FIX20110801 - file name not passed to gzip */
  char * tmp;
  const char * arcname = archive_name_array[0];
  int res, sres;
  size_t len;

  *ab = 0;
  res = -1;
  if (verbose_option > 1) {
      getcwd(cwd,256);
      printf("In current work directory [%s]\n",cwd);
  }
  if( arcname && *arcname )
  {
     len = strlen(arcname);
     strcpy(ob,arcname);
     sres = stat(ob, &_s_sbuf);
     if(sres)
     {  /* failed to find archive file name!
           maybe because '.gz' missing */
        tmp = &ob[len-3];
        if((len > 3) &&
           ( _strnicmp(tmp, ".tar", 4) == 0 ))
        {
           strcat(ob,".gz");  /* try adding '.gz' to file */
           sres = stat(ob, &_s_sbuf);
           if(sres)
           {
              /* failed again, so go back to original */
              strcpy(ab,arcname);   /* user given name */
           }
           else
           {
               strcpy(ab,ob); /* found this archive */
           }
        }
     }
     else
     {
         strcpy(ab,ob); /* found this archive */
     }
     //sprintf(zb, "gzip -d %s", ob );
     sprintf(zb, "gzip -d %s", ab ); /* FIX20110801 - correct name passed to gzip */
     /* let the system fizzle with it */
     res = system(zb);
     /* we're back */
     if(res)
     {
        /* deal with possible error */
        FATAL_ERROR ((0, 0, _("Command [%s] returned %d! gzip may not be in path!!"), zb, res ));
     }
     else
     {
        strcpy(zb, arcname);
        tmp = &zb[len-3];
        if((len > 3) &&
           ( _strnicmp(tmp, ".gz", 3) == 0 ))
        {
           zb[len-3] = 0;
           if( stat( zb, &_s_sbuf ) != 0 )
           {
              sprintf(ob, "WARNING: gzip failed, as file [%s] does not seem to exist!\n", zb );
              fprintf(stderr,ob);
           } else {
              strcpy((char *)arcname,zb);
              if(ro)
                 archive = open(arcname,O_RDONLY); 
           }
        }
     }
  }
  return res;
}

#endif /* _MSC_VER */

