@set TEMPPR=%PROMPT%
@if NOT EXIST setup.bat goto ERR1
call setup
call mdd temp
@if NOT EXIST ..\update.bat goto ERR2
@set PROMPT=# 

@REM # Check that tar --update does not add non-changed directories to the
@REM # archive.
@REM # References: <42AB0D28.6030706@mein-horde.de>
@REM #             by Martin Lohmeier <martin@mein-horde.de>
@REM #             on Sat, 11 Jun 2005 18:11:20 +0200


md directory
@if NOT EXIST directory goto ERR3
genfile --length 10240 --pattern zeros --file directory/file1
genfile --length 10240 --pattern default --file directory/file2
@if NOT EXIST directory\file1 goto ERR4
%TEMPT% cf archive directory
@if ERRORLEVEL 1 goto ERR5
@if NOT EXIST archive goto ERR5
@echo separator
%TEMPT% uf archive directory
@if ERRORLEVEL 1 goto ERR6
@echo separator
%TEMPT% tf archive
@if ERRORLEVEL 1 goto ERR7
@echo Above LIST should be
@echo directory/
@echo directory/file1
@echo directory/file2
@echo.
@echo Success ... ok
@cd ..
@goto END

:ERR1
@echo Can NOT locate setup.bat ... check name, location ...
@goto END

:ERR2
@echo mdd.bat missing, or failed ... check name, location ...
@goto END

:ERR3
@echo ERROR: FAILED TO CREATE directory
@goto WAIT

:ERR4
@echo ERROR: FAILED TO CREATE directory\file1 ... maybe genfile is not in PATH ...
@goto WAIT

:ERR5
@echo ERROR: FAILED TO CREATE archive ... maybe [%TEMPT%] is not a valid tar EXE ...
@goto WAIT

:ERR6
@echo ERROR: FAILED TO UPDATE archive ... maybe [%TEMPT%] is not a valid tar EXE ...
@goto WAIT

:ERR6
@echo ERROR: FAILED TO LIST archive ... maybe [%TEMPT%] is not a valid tar EXE ...
@goto WAIT

:WAIT
cd ..
@set PROMPT=%TEMPPR%
@pause
@goto END

:END
@set PROMPT=%TEMPPR%
