@if NOT EXIST setup.bat goto ERR1
call setup
call mdd temp

genfile --file file1
@if NOT EXIST file1 goto ERR2
genfile --file file2
@if NOT EXIST file2 goto ERR3

@echo Make sure file timestamps in the archive will not differ ...
@set TEMP1=--mtime=./file1

@echo Creating archive.1
%TEMPT% %TEMP1% -cf archive.1 file1 file2
@if NOT EXIST archive.1 goto ERR4


@echo Creating archive.2
%TEMPT% %TEMP1% -cf archive.2 -T nul
@if NOT EXIST archive.2 goto ERR5
%TEMPT% %TEMP1% -rf archive.2 file1
%TEMPT% %TEMP1% -rf archive.2 file2

@echo Comparing archives
fc4 -b archive.1 archive.2
@if ERRORLEVEL 1 goto FAILED
@echo They appear the SAME ...
@goto DONE

:FAILED
@echo They appear different ...
@goto DONE

:DONE
@cd ..
@goto END

:ERR1
@echo Can NOT locate setup.bat ... check name, location ...
@goto END

:ERR2
@echo Can NOT create file1 ... maybe genfile.exe is not in the path ...
@goto WAIT

:ERR3
@echo Can NOT create file2 ... maybe genfile.exe is not in the path ...
@goto WAIT

:ERR4
@echo Can NOT create archive.1 ... maybe %TEMPT% is not available ... fix in setup.bat ...
@goto WAIT

:ERR5
@echo Can NOT create archive.2 ... maybe %TEMPT% is not available ... fix in setup.bat ...
@goto WAIT

:WAIT
@pause

:END
