/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the examples of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:BSD$
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QtCore>
#include <QTime>

#include <stdio.h>
#include <stdlib.h>

QTime rt;

const int DataSize = 200000;
const int BufferSize = 8192;
char buffer[BufferSize];

static int wait_count = 0;
static int wait_count2 = 0;
static int prod_run = 0;
static int cons_run = 0;

QWaitCondition bufferNotEmpty;
QWaitCondition bufferNotFull;
QMutex mutex;
int numUsedBytes = 0;
int offsets[10];

// given millisecond, return appropriate (nice) string
QString getElapTimeStg(int ms)
{
    QString fmt = "";
    if (ms < 1000) {
        fmt.sprintf("%d ms", ms);
    } else {
        int secs = ms / 1000;
        ms = ms % 1000;
        if (secs < 60) {
            if (ms)
                fmt.sprintf("%d.%03d secs", secs, ms);
            else
                fmt.sprintf("%d secs", secs);
        } else {
            int mins = secs / 60;
            secs = secs % 60;
            if (mins < 60) {
                if (ms)
                    fmt.sprintf("%d:%02d.%03d mins", mins, secs, ms);
                else {
                    if (secs)
                        fmt.sprintf("%d:%02d mins", mins, secs);
                    else
                        fmt.sprintf("%d mins", mins);
                }
            } else {
                int hrs = mins / 60;
                mins = mins % 60;
                if (ms)
                    fmt.sprintf("%d:%02d:%02d.%03d hrs", hrs, mins, secs, ms);
                else {
                    if (secs)
                        fmt.sprintf("%d:%02d:%02d hrs", hrs, mins, secs);
                    else {
                        if (mins)
                            fmt.sprintf("%d:%02d hrs", hrs, mins);
                        else
                            fmt.sprintf("%d hrs", hrs);
                    }
                }
            }
        }
    }
    return fmt;
}


class Producer : public QThread
{
public:
    void run();
};

void Producer::run()
{
    fprintf(stderr, "Producer start\n");

    qsrand(QTime(0,0,0).secsTo(QTime::currentTime()));
    
    for (int i = 0; i < DataSize; ++i) {
        prod_run++;
        // ===========================
        mutex.lock();
        if (numUsedBytes == BufferSize) {
            wait_count++;
            bufferNotFull.wait(&mutex);
        }
        mutex.unlock();
        // ===========================
        int offset = (int)qrand() % 10;
        //buffer[i % BufferSize] = "ACGT"[(int)qrand() % 4];
        buffer[i % BufferSize] = "0123456789"[offset];
        offsets[offset] += 1;

        // bump used =================
        mutex.lock();
        ++numUsedBytes;
        bufferNotEmpty.wakeAll();
        mutex.unlock();
        // ============================
    }
    fprintf(stderr, "\nProducer end\n");
}

class Consumer : public QThread
{
public:
    void run();
};

void Consumer::run()
{
    fprintf(stderr, "Consumer start\n");
    int counter, max_chars;
    int prev_ms = -1;
    max_chars = 75;
    counter = 0;
    for (int i = 0; i < DataSize; ++i) {
        cons_run++;

        mutex.lock();
        if (numUsedBytes == 0) {
            wait_count2++;
            bufferNotEmpty.wait(&mutex);
        }
        mutex.unlock();

        fprintf(stderr, "%c", buffer[i % BufferSize]);
        counter++;
        if (counter >= max_chars) {
            counter = 0;
            int wc1 = wait_count;
            int wc2 = wait_count2;
            int pc1 = prod_run;
            int pc2 = cons_run;
            wait_count = 0;
            wait_count2 = 0;
            if (pc1 == DataSize) {
                fprintf(stderr, " (prod_done %d:%d",
                    pc2, wc2);
            } else {
                fprintf(stderr, " (%d:%d %d:%d",
                    pc1, wc1,
                    pc2, wc2);
            }
            int ms = rt.elapsed();
            if ((ms != prev_ms)||wc1||wc2) {
                QString tm = getElapTimeStg(ms);
                fprintf(stderr, " %s", tm.toStdString().c_str());
                prev_ms = ms;
            }
            fprintf(stderr, ")\n");
        }

        mutex.lock();
        if (numUsedBytes)
            --numUsedBytes;
        bufferNotFull.wakeAll();
        mutex.unlock();
    }
    fprintf(stderr, "\nConsumer end\n");
}



int main(int argc, char *argv[])
{
    rt.start();
    QCoreApplication app(argc, argv);
    int pump_cnt = 0;
    int pump_cnt2 = 0;
    int i;

    for (i = 0; i < 10; i++)
        offsets[i] = 0;

    Producer producer;
    Consumer consumer;
    fprintf(stderr, "Start producer\n");
    producer.start();
    fprintf(stderr, "Start consumer\n");
    consumer.start();

    // But this MAIN thread could do its OWN thing
    // and NOT just wait for the other threads to end
    while ( !producer.isFinished() ) {
        // some third action
        for (int i = 0; i < 1000; i++) {
            pump_cnt++;
            if (pump_cnt == 0)
                pump_cnt2++;
            if (producer.isFinished())
                break;
        }
    }

    fprintf(stderr, "\nMain did %d:%d cycles, waiting for producer to finish.\n", pump_cnt2, pump_cnt);


    fprintf(stderr, "Wait producer ended\n");
    producer.wait();
    fprintf(stderr, "\nProducer ended\n");

    fprintf(stderr, "\nWait consumer ended\n");
    consumer.wait();
    fprintf(stderr, "\nConsumer ended\n");

    fprintf(stderr, "Rand off cnts: ");
    pump_cnt = 0;
    for (i = 0; i < 10; i++) {
        pump_cnt += offsets[i];
        fprintf(stderr, "%d:%d ", i, offsets[i] );
    }
    fprintf(stderr, "Tot %d\n", pump_cnt);

    QString tm = getElapTimeStg(rt.elapsed());
    fprintf(stderr, "\nApp exit in %s\n", tm.toStdString().c_str());

    return 0;
}

