#include "textfind.h"
#include "ui_textfind.h"
#include <QFile>
#include <QString>
#include <QFileDialog>
#include <QTextStream>
#include <QFileInfo>
#include <QSettings>
#include <QTextDocument>
#include <QMessageBox>
#include <QTextCursor>
#include <QTextCharFormat>
#include <QDateTime>
#include <QTimer>
#include <QTime>

#include "FindDialog.h"

QString m_appOrig = "GTools";
QString m_appName = "textfind";
QString m_lastDir;
QString m_lastFile;
QString m_lastFind;
QString m_plastDir = "dirs/lastDir";
QString m_plastFile = "files/lastFile";
QString m_plastFind = "find/lastFind";

QString m_find_Opts;

FindDialog * m_pFind;
QPushButton* dlg_findButton;

QTextDocument::FindFlag m_find_Flag = QTextDocument::FindWholeWords;
// QTextDocument::FindBackward
// QTextDocument::FindCaseSensitively

QSettings m_settings(m_appOrig,m_appName); // establish persistent settings
// WIN32: In registry - HKEY_CURRENT_USER/Software/TerraGear/<name>
// unix: $HOME/.config/<app name>.conf, in an INI file format

bool isFirstTime = true;

QTimer m_timer;
QTime m_runTime;

// given millisecond, return appropriate (nice) string
static QString getElapTimeStg(int ms)
{
    QString fmt = "";
    if (ms < 1000) {
        fmt.sprintf("%d ms", ms);
    } else {
        int secs = ms / 1000;
        ms = ms % 1000;
        if (secs < 60) {
            if (ms)
                fmt.sprintf("%d.%03d secs", secs, ms);
            else
                fmt.sprintf("%d secs", secs);
        } else {
            int mins = secs / 60;
            secs = secs % 60;
            if (mins < 60) {
                if (ms)
                    fmt.sprintf("%d:%02d.%03d mins", mins, secs, ms);
                else if (secs)
                    fmt.sprintf("%d:%02d mins", mins, secs);
                else
                    fmt.sprintf("%d mins", mins);
            } else {
                int hrs = mins / 60;
                mins = mins % 60;
                if (ms)
                    fmt.sprintf("%d:%02d:%02d.%03d hrs", hrs, mins, secs, ms);
                else if (secs)
                    fmt.sprintf("%d:%02d:%02d hrs", hrs, mins, secs);
                else if (mins)
                    fmt.sprintf("%d:%02d hrs", hrs, mins);
                else
                    fmt.sprintf("%d hrs", hrs);
            }
        }
    }
    return fmt;
}


textfind::textfind(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::textfind)
{
    ui->setupUi(this);
    m_lastDir = m_settings.value(m_plastDir,"").toString();
    m_lastFile = m_settings.value(m_plastFile,"input.txt").toString();
    QFile f(m_lastFile);
    if (f.exists()) {
        loadlastFile();
    }

    m_pFind = new FindDialog(this);
    m_pFind->show();
    connect(m_pFind->findButton, SIGNAL(clicked()), this, SLOT(on_find_clicked()));
    // OR MAYBE
    // but this FAILED (and read other posts where this sometimes failed!)
    // dlg_findButton = qFindChild<QPushButton*>(m_pFind, "findButton");
    // connect(dlg_findButton, SIGNAL(clicked()), this, SLOT(on_find_clicked()));

    m_lastFind = m_settings.value(m_plastFind,"").toString();
    if (m_lastFind.size()) {
        // set local edit box
        ui->lineEdit_find->setText(m_lastFind);
        // and find dialog edit box
        m_pFind->set_Find(m_lastFind);
    }

    m_timer.start(1000); //timer will emit timeout() every second
    connect(&m_timer, SIGNAL(timeout()), this, SLOT(slotTimeout()));
    m_runTime.start();
}

textfind::~textfind()
{
    delete ui;
}

void textfind::on_pushButton_clicked()
{
    close();
}

void textfind::loadopenFile(QFile & inputFile)
{
    QTextStream in(&inputFile);
    QString line = in.readAll();
    inputFile.close();

    ui->textEdit->setText(line);
    ui->textEdit->setUndoRedoEnabled(false);
    ui->textEdit->setUndoRedoEnabled(true);

    QFileInfo fi(inputFile);
    m_lastDir = fi.absoluteFilePath();
    m_settings.setValue(m_plastDir,m_lastDir);
    m_lastFile = inputFile.fileName();
    m_settings.setValue(m_plastFile,m_lastFile);
    QString tmp;
    tmp.sprintf(", size %ld bytes", (long)fi.size());
    ui->label_filename->setText("LOADED: "+m_lastFile+tmp);
}

void textfind::loadlastFile()
{
    bool ok = true;
    QFile inputFile(m_lastFile);
    if (!inputFile.open(QIODevice::ReadOnly)) {
        ok = false;
        if (!ok)
            return;
    }
    loadopenFile(inputFile);
}

void textfind::loadnewFile()
{
    bool ok = true;
    //QFile inputFile(":/forms/input.txt");
    QFile inputFile;
    ok = false;
    QString newfile;
    newfile = QFileDialog::getOpenFileName(this,tr("Open text file for searching"),
                                           m_lastDir, tr("All (*)"));
    if (newfile.size() && inputFile.exists(newfile)) {
        inputFile.setFileName(newfile);
        if (inputFile.open(QFile::ReadOnly)) {
            ok = true;
        }
    }
    if (!ok)
        return;
    loadopenFile(inputFile);
}

void textfind::on_pushButton_2_clicked()
{
    loadnewFile();
}


void textfind::on_pushButton_find_clicked()
{
    QString searchString = ui->lineEdit_find->text();
    QTextDocument *document = ui->textEdit->document();
    QString tmp = "";
    bool found = false;
    int count = 0;
    ui->label_found->setText(tmp);

    if (isFirstTime == false)
        document->undo();

    if (searchString.isEmpty()) {
        QMessageBox::information(this, tr("Empty Search Field"),
                "The search field is empty. Please enter a word and click Find.");
    } else {

        QTextCursor highlightCursor(document);
        QTextCursor cursor(document);

        cursor.beginEditBlock();

        QTextCharFormat plainFormat(highlightCursor.charFormat());
        QTextCharFormat colorFormat = plainFormat;
        colorFormat.setForeground(Qt::red);

        while (!highlightCursor.isNull() && !highlightCursor.atEnd()) {
            // do the text find
            highlightCursor = document->find(searchString,
                                             highlightCursor,
                                             m_find_Flag);

            if (!highlightCursor.isNull()) {
                found = true;
                count++;
                highlightCursor.movePosition(QTextCursor::WordRight,
                                       QTextCursor::KeepAnchor);
                highlightCursor.mergeCharFormat(colorFormat);
            }
        }

        cursor.endEditBlock();
        isFirstTime = false;

        if (found == false) {
            tmp = "Sorry, the word ["+searchString+"] cannot be found";
            if (m_find_Opts.size())
                tmp += ", with options "+m_find_Opts;
            QMessageBox::information(this, tr("Word Not Found"),tmp);
        } else {
            tmp.sprintf("%d",count);
            tmp = "Item ["+searchString+"] found "+tmp+" times";
            if (m_find_Opts.size())
                tmp += ", with options "+m_find_Opts;
            ui->label_found->setText(tmp);
            m_settings.setValue(m_plastFind,searchString); // and keep the last find
        }
    }
}

void textfind::on_find_clicked()
{
    if (m_pFind) {
        //QString text = m_pFind->lineEdit->text();
        QString text = m_pFind->get_Find();
        if (text.size()) {
            ui->lineEdit_find->setText(text);
            // fix the find flag
            m_find_Opts = "";
            QTextDocument::FindFlag prev = m_find_Flag;
            int value = 0;
            m_find_Flag = (QTextDocument::FindFlag)0;

            //if (m_pFind->wholeWordsCheckBox->isChecked()) // = new QCheckBox(tr("&Whole words"));
            if (m_pFind->isWholeWord()) {
                value |= QTextDocument::FindWholeWords;
                m_find_Opts += "Whole ";
            }

            // QCheckBox *caseCheckBox;
            if (m_pFind->isCaseCheck()) {
                value |= QTextDocument::FindCaseSensitively;
                m_find_Opts += "Case ";
            }

            // HOW TO IMPLEMENT THESE FEATURES ???
            // backwardCheckBox = new QCheckBox(tr("Search &backward"));
            // searchSelectionCheckBox = new QCheckBox(tr("Search se&lection"));
            // QCheckBox *fromStartCheckBox;

            m_find_Flag = (QTextDocument::FindFlag)value;
            on_pushButton_find_clicked();

            m_find_Flag = prev;
            m_find_Opts = "";
        }
    }
}

// timer.start(1000); //timer will emit timeout() every second
// connect(&timer, SIGNAL(timeout()), this, SLOT(slotTimeout()));
void textfind::slotTimeout()
{
    QDateTime datetime = QDateTime::currentDateTime();
    QString dt = datetime.toString("yyyy/MM/dd HH:mm:ss");
    QString rt = getElapTimeStg(m_runTime.elapsed());
    ui->label_time->setText(rt+" "+dt);

}
