@setlocal
@echo # Script to do some testing of various transformations depending on datum
@echo # files that are not always available.
@echo #

@if NOT "%PROJ_LIB%x" == "x" goto DNLIB
@set PROJ_LIB=..\..\nad
:DNLIB
@REM To SEE what is, and is NOT loaded...
@REM set PROJ_DEBUG=9

@set EXE=bin\cs2cs.exe
@set OUT=temp_td_out.txt
@set INP=temp_in.txt
@set DIST=%PROJ_LIB%\td_out.dist

@if NOT EXIST %EXE% goto NOEXE
@if NOT EXIST %PROJ_LIB%\. goto NODIR

@REM Test for GNU type 'diff' in the PATH
@diff --version >nul
@if ERRORLEVEL 1 goto USECOMP
@set DIFF=diff -w
@echo Found, and using [%DIFF%] for the difference at the end...
@goto DNDIFF

:USECOMP
@REM NO the windows native 'comp.exe' will NOT 'ignore spaces'!!!
@REM So do NOT do a DIFF !!!
@set DIFF=NO
@echo NOTE: diff NOT found in PATH, so CAN NOT DO a difference at the end. Not good...
@echo Go to http://unxutils.sourceforge.net/ for Native Win32 ports of some GNU utilities
@echo and extract and place the 'diff.exe' in a folder in your PATH environment.
@echo.
:DNDIFF

@if EXIST %DIST% goto DNDIST
@echo.
@echo WARNING: Can NOT locate file [%DIST%]! So will be UNABLE to do comparison at end...
@echo.
:DNDIST

@echo *** CONTINUE? *** Ctrl+C to abort... Environment [PROJ_LIB=%PROJ_LIB%]
@if "%TEMPNP%x" == "yesx" (
@echo NO PAUSE [TEMPNP=yes] set in environment...
@set EXE=@%EXE%
) else (
@pause
)

@echo ============================================
@echo Running %0, using %EXE%, PROJ_LIB=%PROJ_LIB%
@echo ============================================

@if EXIST %OUT% @del %OUT%

@echo Doing tests into file [%OUT%], please wait...

@echo ############################################################## >> %OUT%
@echo 1st through ntv1, 2nd through conus >> %OUT%

@echo 111d00'00.000"W 44d00'00.000"N 0.0 >%INP%
@echo 111d00'00.000"W 39d00'00.000"N 0.0 >>%INP%
%EXE% +proj=latlong +ellps=clrk66 +nadgrids=ntv1_can.dat,conus +to +proj=latlong +datum=NAD83 -E %INP% >>%OUT%

@echo ############################################################## >> %OUT%
@echo As above, but without ntv1 everything goes through conus file. >> %OUT%
@echo 111d00'00.000"W 44d00'00.000"N 0.0 >%INP%
@echo 111d00'00.000"W 39d00'00.000"N 0.0 >>%INP%
%EXE% +proj=latlong +ellps=clrk66 +nadgrids=conus +to +proj=latlong +datum=NAD83 -E %INP% >>%OUT%

@echo ############################################################## >> %OUT%
@echo Test MD used where available >> %OUT%

@echo 79d58'00.000"W 37d02'00.000"N 0.0 >%INP%
@echo 79d58'00.000"W 36d58'00.000"N 0.0 >>%INP%
%EXE% +proj=latlong +ellps=clrk66 +nadgrids=MD,conus +to +proj=latlong +datum=NAD83 -E %INP% >>%OUT%

@echo 79d58'00.000"W 37d02'00.000"N 0.0 >%INP%
@echo 79d58'00.000"W 36d58'00.000"N 0.0 >>%INP%
%EXE% +proj=latlong +ellps=clrk66 +nadgrids=conus +to +proj=latlong +datum=NAD83 -E %INP% >>%OUT%

@REM ##############################################################################
@REM # Done! 

@if EXIST %DIST% goto DoDiff
@echo Did NOT find file [%DIST%], so can NOT do a comparision...
@echo so no real way to tell if the output was all good from [%EXE%]
@echo to file %OUT%, but you can visually check it...
@goto FAILED

:DoDiff
@if "%DIFF%x" == "NOx" goto NODIFF
@echo Doing %DIFF% %OUT% with %DIST%
@%DIFF% %OUT% %DIST% >nul
@if ERRORLEVEL 1 goto CHKDIFF
@call testok
@goto END

:CHKDIFF
@call testbad
@goto FAILED

:NODIFF
@echo Did NOT find [diff.exe], so can NOT do a comparision...
@echo so no real way to tell if the output was all good from [%EXE%]
@echo to file %OUT%, but you can visually check it...
@echo Go to http://unxutils.sourceforge.net/ for a native Win32 port of some GNU utilities
@echo and extract and place the 'diff.exe' in a folder in your PATH environment.
@goto FAILED

:NOEXE
@echo ERROR: Can NOT locate %EXE% file! Check name, location, and FIX
@goto FAILED
:NONAD
@echo ERROR: Can NOT locate %INIT_FILE% file! Check name, location, and FIX
@goto FAILED
:NODIR
@echo ERROR: Can NOT locate %PROJ_LIB% directory! Check name, location, and FIX
@goto FAILED

:FAILED
@if EXIST %INP% @del %INP%
@endlocal
@set TEMPFAILED=yes
@if "%TEMPNP%x" == "yesx" (
@pause
)
@goto DONE

:END
@if EXIST %INP% @del %INP%
@endlocal
:DONE
