@setlocal
@echo Just various cs2cs.exe tests scraped from various places...
@REM cs2cs +proj=latlong +datum=NAD83 +to +proj=utm +zone=10  +datum=NAD27 -r <<EOF
@REM   45d1533.1"   111.5W
@REM   45d15.551666667N   -111d30
@REM   +45.25919444444    111d30000w
@REM   EOF

@if NOT "%PROJ_LIB%x" == "x" goto DNLIB
@set PROJ_LIB=..\..\nad
:DNLIB
@REM To SEE what is, and is NOT loaded...
@REM set PROJ_DEBUG=5

@set EXE=bin\cs2cs.exe
@if NOT EXIST %EXE% goto NOEXE
@if NOT EXIST %PROJ_LIB%\. goto NODIR

@set INP=temp_in.txt

@if EXIST %INP% @del %INP%

@echo *** CONTINUE? *** Ctrl+C to abort... Environment [PROJ_LIB=%PROJ_LIB%]
@if "%TEMPNP%x" == "yesx" (
@echo NO PAUSE [TEMPNP=yes] set in environment...
@set EXE=@%EXE%
) else (
@pause
)

@echo ============================================
@echo Running %0, using %EXE%, PROJ_LIB=%PROJ_LIB%
@echo ============================================

@echo 45d15'33.1^"   111.5W > %INP%
@echo 45d15.551666667N -111d30 >>%INP%
@echo +45.25919444444 111d30'000w >>%INP%
@if NOT EXIST %INP% goto NOFILE
@echo.
@echo List in file...
@type %INP%

@echo Do nothing...
%EXE% +proj=latlong +datum=NAD83 +to +proj=latlong +datum=NAD83 -r %INP%
@echo Convert...
%EXE% +proj=latlong +datum=NAD83 +to +proj=utm +zone=10 +datum=NAD27 -r %INP%

@echo WGS84 to Mercator
%EXE% +proj=latlong +datum=WGS84 +to +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +no_defs -r %INP%
%EXE% +proj=latlong +datum=WGS84 +to +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs -r %INP%

@REM 2nd set of tests
@REM ================

@if EXIST %INP% @del %INP%
@echo 5076275.42 1402224.58  > %INP%
@REM echo 1402224.58      5076275.42 -0.00 >%INP%
@REM 1402224.58      5076275.42 -0.00
@REM 1402224.58      5076275.42 -0.00
@if NOT EXIST %INP% goto NOFILE

@echo.
@echo List in file
@type %INP%
@echo.

%EXE% +proj=utm +zone=10 +datum=NAD27 +to +proj=latlong +datum=NAD83 -r %INP%
%EXE% +proj=utm +zone=10 +datum=NAD27 +to +proj=utm +zone=10 +datum=NAD27 -r %INP%

@echo.
@echo All done...
@goto END

:NOFILE
@echo ERROR: Can NOT locate file [%INP%]! Check name, location, and FIX...
@goto FAILED
:NOFILE2
@echo ERROR: Can NOT locate file [%INP2%]! Check name, location, and FIX...
@goto FAILED

:NOEXE
@echo ERROR: Can NOT locate EXE [%CS2CS%]! Check name, location, and FIX
@goto FAILED
:NODIR
@echo ERROR: Can NOT locate %PROJ_LIB% directory! Check name, location, and FIX
@goto FAILED

:FAILED
@if EXIST %INP% @del %INP%
@endlocal
@set TEMPFAILED=yes
@if "%TEMPNP%x" == "yesx" (
@pause
)
@goto DONE

:END
@if EXIST %INP% @del %INP%
@endlocal
:DONE
