@setlocal
@REM =============================================================================
@REM Setup fo the 'nad' folder, after ZIP download and unpack
@REM from http://trac.osgeo.org/proj/wiki, get proj-datumgrid-1.5.zip, or later...
@REM UNZIP into the 'nad' folder, where you find nad27 and nad83...
@REM =============================================================================

@set THISDIR=contrib\msvc
@set NADEXE=bin\nad2bin.exe
@set CONUS=..\..\nad\conus.lla

@if NOT EXIST %NADEXE% goto ERR1
@if NOT EXIST %CONUS% goto ERR2
@REM Check out location...
@if NOT EXIST ..\..\%THISDIR%\setup-nads.bat goto BADPLACE

@set TEMPD=0
@set TEMPC=0
@set TEMPOVR=
@set TEMPFND=
@cd ..\..\nad
@for %%i in (*.lla) do @(call :CHKIT %%i)
@cd ..\contrib\msvc

@if "%TEMPFND%x" == "x" goto NOTHING

@echo Found the required tools and %TEMPD% data files to process...
@echo Data list = [%TEMPFND%]

@if NOT "%TEMPOVR%x" == "x" goto ABORT
@echo *** CONTINUE? ***
@pause

@cd ..\..\nad
@for %%i in (*.lla) do @(call :DOIT %%i)
@cd ..\contrib\msvc

@goto END

:CHKIT
@if "%1x" == "x" goto :EOF
@set TEMPFND=%TEMPFND% %1
@set BASE=%~n1
@set /A TEMPD+=1
@if EXIST %BASE% (
@set /A TEMPC+=1
@set TEMPOVR=%TEMPOVR% %TEMPC%=[%BASE%]
)
@goto :EOF

:DOIT
@if "%1x" == "x" goto :EOF
@set BASE=%~n1
@echo Base [%BASE%] from [%1]
@set TEMPX=..\%THISDIR%\%NADEXE%
@if NOT EXIST %TEMPX% goto NOEXE
@if EXIST %BASE% goto NO_OVER
%TEMPX% %BASE% < %1
@if ERRORLEVEL 1 goto FAILED1
@if NOT EXIST %BASE% goto FAILED2
@goto :EOF

:NO_OVER
@echo File %BASE% already EXISTS!
@echo Will NOT overwrite...
@pause
@goto END

:FAILED1
@echo %NADEXE% returned ERRORLEVEL=%ERRORLEVEL%
@echo Should abort - Ctrl+C and investigate...
@pause
@echo Should abort - Ctrl+C and investigate...
@pause
@echo Should abort - Ctrl+C and investigate...
@pause
@echo Should abort - Ctrl+C and investigate...
@pause
@echo Should abort - Ctrl+C and investigate...
@pause
@echo ok, I give up ;=))
@goto END

:FAILED2
@echo %NADEXE% failed to create %BASE%
@echo Should abort - Ctrl+C and investigate...
@pause
@echo Should abort - Ctrl+C and investigate...
@pause
@echo Should abort - Ctrl+C and investigate...
@pause
@echo Should abort - Ctrl+C and investigate...
@pause
@echo Should abort - Ctrl+C and investigate...
@pause
@echo ok, I give up ;=))
@goto END

:NOEXE
@echo Presently in directory [%CD%]
@echo Can NOT locate file [%TEMPX%]!
@echo CAN NOT CONTINUE! Use Ctrl+C to ABORT
@pause
@echo CAN NOT CONTINUE! Use Ctrl+C to ABORT
@pause
@echo CAN NOT CONTINUE! Use Ctrl+C to ABORT
@pause
@echo CAN NOT CONTINUE! Use Ctrl+C to ABORT
@pause
@echo GIVE UP TRYING ;=))
@goto END

:BADPLACE
@echo.
@echo ERROR: Directory arrangement problem!
@echo Expected [..\..\%THISDIR%\setup-nads.bat] to point to this file!
@echo.
@goto END


:ERR1
@echo ERROR: Can NOT find EXE file %NADEXE%! Check name, location, and FIX
@goto END

:ERR1
@echo.
@echo ERROR: Can NOT find data file %CONUS%! Check name, location, and FIX
@echo Or DOWNLOAD and unpack the proj-datumgrid-1.5.zip, or later...
@echo from http://trac.osgeo.org/proj/wiki
@echo and UNZIP into the 'nad' folder, where you find nad27 and nad83...
@echo Then run this batch file again...
@echo.
@goto END

:ABORT
@echo.
@echo ERROR: Found some generated files already EXIST!
@echo List = %TEMPOVR%
@echo *** WILL NOT OVERWRITE THESE %TEMPC% EXISTING FILES! ***
@echo Delete, move, rename, to run this batch again...
@echo.
@goto END

:NOTHING
@echo.
@echo ERROR: Presently in directory [%CD%], but
@echo found NO files of the form *.lla to process...
@echo Have you downloaded and unpacked the Datum zip?
@echo.
@goto END

:END
@endlocal
