#!/bin/sh
# created geoff mclane Tue Mar  8 15:05:13 CET 2011 report@geoffair.info
BN=`basename $0`
PREFIX="--prefix=$HOME"
OPTIONS=""
set -e
if [ -f "autogen.sh" ]; then
   if [ ! -x autogen.sh ]; then
      chmod +x autogen.sh
   fi
   if [ -f configure ]; then
      rm -v -f configure
   fi
   if [ -f Makefile ]; then
      rm -v -f Makefile
   fi
   echo "$BN: Running autogen.sh..."
   ./autogen.sh
   echo "$BN: Done autogen.sh..."
   if [ ! -f configure ]; then
      echo ""
      echo "$BN: ERROR: configure file not created..."
      echo ""
      exit 1
   fi
   echo "$BN: Doing: ./configure $PREFIX $OPTIONS"
   ./configure $PREFIX $OPTIONS
   echo ""
   echo "$BN: Done configure - CHECK CAREFULLY, and READ config.log file..."
   echo ""
   if [ ! -f Makefile ]; then
      echo ""
      echo "$BN: ERROR: Makefile not created..."
      echo ""
      exit 1
   fi
   echo "$BN: Doing: 'make'"
   make
   echo "$BN: Done 'make'"
   echo ""
   echo "$BN: configure was [$PREFIX $OPTIONS]"
   if [ -z "$PREFIX" ]; then
      echo "$BN: Will INSTALL to /usr/bin"
   else
      echo "$BN: Will INSTALL to [$PREFIX/bin]. This location SHOULD be in your PATH!"
   fi
   echo "$BN: Ready for 'make install', if NO errors... Need 'sudo' if NOT your install folder."
   echo ""
else
   echo ""
   echo "$BN: can not locate 'autogen.sh'..."
   echo ""
   exit 1
fi
exit 0
