#!/usr/bin/perl -w
# NAME: vcproj05.pl
# AIM: To scan a VCPROJ file, and show the results, and write (temp) DSP/DSW files.
# Since this is all about MSVC things, no attempt has been made to run it in unix.
# 01/12/2010 - Some updates for VC90
# 24/11/2010 - Add in VC10 support - 
# 04/08/2010 - More special fixes for various things...
# 2010/07/30 - Special fix of Simgear.cs to SimGear-cs to suit my system... see $dbg_sl_14
# 2010/05/31 - For FLTK project, include *.fl in 'C' sources
# 2010/05/01 - Fixed -dsp=. (ie a relative input) to absolute using like $sarg = File::Spec->rel2abs($tmp);   # get ABSOLUTE path of output
# 2010/04/23 - Add -ll to load log, and -fix-rel, to FIX the relative source and /I to the dsp output directory
# 2010/04/18 - Remove WARNING: DOES NOT CONTAIN(12) 'Filter'?, and use a default filter
# 2010/03/08 - Remove write tempvcx.xml from scanvc.pl, or only to perl base directory...
# 2010/03/01 - if vcproj contains IgnoreDefaultLibraryNames="MSVCRT", add /nodefaultlib:"MSVCRT" to DSP
#   Add this to the -NEW_OUT- substitution parameter - that is to the # ADD LINK32 line.
#   Can be DIFFERENT per configuration. Altered scanvc.pl to collect this, and fgdsphdrs03.pl to do substitution
# 2010/01/16 - Feeling confident of scans and dsp written - add write actual replacement!
# BUT first, begin to use File::Spec...
# 2009/11/11 - Final tidying up - seems to work fine...
# 2009/10/20 - support MULTIPLE configurations - not compatible with previous versions
# which alwasy had only 2 configurations - Debug and Release.
# 20090912 - add display of CWD, if can not find INPUT file name...
# This uses the services in scanvc.pl, to standardise the processing of a VCPROJ file
# so this is very different to vcproj03.pl, which had its own services to do the scan.
# 2009/09/22 - separarate into multiple 'temp' DSP outputs, using -NEW_PROJECT_NAME-
# but also avoid overwrtting previous out of same name...
# 2010/01/14 - add a DSP COMPARE, if one already exist, and if requested...
# 2009-06-05 also try to attempt to output what the project will create... exe,lib,dll,...
# 05/12/2008 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use Cwd;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use File::Spec; # File::Spec->rel2abs($rel); # we are IN the SLN directory, get ABSOLUTE from RELATIVE
unshift(@INC, 'C:/GTools/perl');
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl'! Check location and \@INC content.\n";
require 'lib_dsphdrs.pl' or die "Unable to load 'lib_dsphdrs.pl'! Check location and \@INC content.\n";
require 'lib_vcscan.pl' or die "Unable to load 'lib_vcscan.pl'! Check location and \@INC content.\n";
#require 'fgutils02.pl' or die "Unable to load fgutils02.pl ...\n";
#require 'fgdsphdrs03.pl' or die "Unable to load fgdsphdrs03.pl ...\n";
#require 'scanvc.pl' or die "Unable to load scanvc.pl ...\n";
# *** OR *** but this is now older, and not as full as scanvc.pl
### require 'fgscanvc03.pl' or die "Unable to load fgscanvc03.pl ...\n";
# log file stuff
my ($LF);
my $perl_base = "C:\\GTools\\perl"; # perl directory
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $perl_base."\\temp.$pgmname.txt";
open_log($outfile);

# features
my $debug_on = 0;   # 0 for release, but on to load default input (when using the editor say)
my $load_log = 0;   # load LOG file at end
my $write_dsp = 1;
my $out_dsp_dir = $perl_base;   # this can be changed by -dsp=<new_dir>
my $g_had_dsp = 0;  # if given an OUTPUT DSP directory
# my $dbg_val = 4+2;    # 1=split defines, 2=no show defines, etc, 4=show sources;
my $dbg_val = 0;    # 1=split defines, 2=no show defines, etc, 4=show sources;
#my $dbg4write = -1; # everything ON
my $dbg4write = 0; # nothing ON
#my $dbg4write = 1; # minimal ON
#my $dbg4write = 2; # show source files ON
my $comp_2_dsps = 0;
my $out_bat_file = $perl_base."\\tempcopydsp.bat";
my $fix_rel_paths = 0;  # if given an output dsp directory, fix the releative source paths
my $debug_dsw_write = 0;   # write DSW debug silently
#my $debug_dsw_write = -1;   # add write DSW debug info

# program variables
my $in_file = '';
my $sln_path = '';
my $active_project = '';    # active project during chk_relative_paths

if ($debug_on) {
    $in_file = 'C:\Projects\curl-7.20.1\lib\libcurl.vcproj';
    $out_dsp_dir = 'C:\Projects\curl-7.20.1\packages\Win32\msvc';
    $fix_rel_paths = 1;
    $load_log = 1;
    #$in_file = 'C:\FG\32\Atlas\projects\msvc\Atlas.sln';
    #$in_file = 'C:\FG\32\Atlas\Atlas.sln';
    #$in_file = 'C:\FG\32\sggeod\projects\msvc\sggeod.sln';
    #$in_file = 'C:\FG\32\fgfs\fgfs.sln';
    #$in_file = 'C:\GTools\ConApps\test\testcon.vcproj';
    #$in_file = 'C:\GTools\ConApps\test\testwin.vcproj';
    #$in_file = 'C:\GTools\ConApps\test\TEST.sln';
    #$in_file = 'C:\Projects\hb\x264\build\win32\libx264.vcproj';
    #$in_file = "C:\\Projects\\hb\\lame\\vc_solution\\vc9_lame.sln";
    #$in_file = "C:\\Projects\\hb\\dirac\\win32\\VisualStudio\\dirac.sln";
    #$in_file = 'C:\Projects\hb\mp4v2\vstudio9.0\libmp4v2\libmp4v2.vcproj';
    #$in_file = 'C:\Projects\hb\libogg\win32\VS2008\libogg_static.sln';
    #$in_file = 'C:\Projects\hb\zlib\contrib\vstudio\vc8\zlibvc.sln';
    #$in_file = 'C:\Projects\hb\zlib\contrib\vstudio\vc7\zlibvc.vcproj';
    #$in_file = 'C:\Projects\freetype-2.3.9\builds\win32\vc2008\freetype.vcproj';
    #$in_file = 'C:\FG\27\TaxiDraw\msvc\7.1\TaxiDraw.vcproj';
    #$in_file = 'C:\FG\27\zlib-1.2.3\projects\visualc6\zlib.vcproj';
    #$in_file = 'C:\FG\27\FlightGear\projects\vc7.1\terrasync.vcproj';
    #$in_file = 'C:\FG\FGRUN\fgrunplib\fgrun.vcproj';
}

my @warnings = ();

#-- get current directory
my $pwd = cwd();

my @dsp_file_list = (); # simple list
my @project_list = ();  # [0]=name [1]=file
my $sln_root_dir = '';  # if given a SOLUTION FILE

# debug 
my $dbg_sl_01 = 0;
my $dbg_sl_02 = 0;
my $dbg_sl_03 = 0;
my $dbg_sl_04 = 0;   # show_hash_results3($rh) if ($dbg_sl_04);
my $dbg_sl_05 = 0;   # prt( "[dbg_s105] $pgmname: Scanning [$in]...\n" ) if ($dbg_sl_05);
my $dbg_sl_06 = 0;  # show parse_arg in detail
my $dbg_sl_07 = 0; # prt("[dbg_sl_07] Check relative vcd=[$vcd], out=[$outd]\n") if ($dbg_sl_07);
my $dbg_sl_08 = 0; # chk_relative_paths: show each config item
my $dbg_sl_09 = 0; # chk_relative_paths: show each source item, and any CHANGE
my $dbg_sl_10 = 0; # chk_relative_paths: show each other config item, and any CHANGE
my $dbg_sl_11 = 0; # chk_relative_paths: show any POST changes -NEW_POST-
my $dbg_sl_12 = 0; # debug sub get_new_post_string($$$$$) { # $v2,\$ok,$rp,$vcd,$outd);
my $dbg_sl_13 = 0;
my $dbg_sl_14 = 0;
my $dbg_sl_15 = 0; # prt( "Stored \$sln_projpath{$projname} = [0:$projfile,1:$projff,2:$relpath,3:$dspfile,4:$fdspfil]\n");
my $dbg_sl_16 = 1; # show each project, and its ID, as found

sub get_sl_debug_stg() {
    my $stg = '';
    if ($dbg_sl_01) { $stg .= "01 "; }; if ($dbg_sl_02) { $stg .= "02 "; };
    if ($dbg_sl_03) { $stg .= "03 "; }; if ($dbg_sl_04) { $stg .= "04 "; };
    if ($dbg_sl_05) { $stg .= "05 "; }; if ($dbg_sl_06) { $stg .= "06 "; };
    if ($dbg_sl_07) { $stg .= "07 "; }; if ($dbg_sl_08) { $stg .= "08 "; };
    if ($dbg_sl_09) { $stg .= "09 "; }; if ($dbg_sl_10) { $stg .= "10 "; };  if ($dbg_sl_11) { $stg .= "11 "; };
    if ($dbg_sl_12) { $stg .= "12 "; }; if ($dbg_sl_13) { $stg .= "13 "; };
    if ($dbg_sl_14) { $stg .= "14 "; };
        
    $stg .= "dbg4Write=$dbg4write " if ($dbg4write);
    $stg .= "debug_dsw_write=$debug_dsw_write " if ($debug_dsw_write);

    return $stg;
}

sub set_sl_debug_val($) {
    my ($v) = shift;
    $dbg_sl_01 = $v; $dbg_sl_02 = $v; $dbg_sl_03 = $v; $dbg_sl_04 = $v; $dbg_sl_05 = $v;
    $dbg_sl_06 = $v; $dbg_sl_07 = $v; $dbg_sl_08 = $v; $dbg_sl_09 = $v; $dbg_sl_10 = $v; $dbg_sl_11 = $v;
    $dbg_sl_12 = $v; $dbg_sl_13 = $v; $dbg_sl_14 = $v;
}

sub set_sl_debug_on() { set_sl_debug_val(1); $load_log = 1; }
sub set_sl_debug_off() { set_sl_debug_val(0); }

my $curr_app_type = '';
# APP_TYPE
# $app_console_stg  = 'Console Application'  = get_dsp_head_console
# $app_windows_stg  = 'Application'          = get_dsp_head_app
# $app_dynalib_stg  = 'Dynamic-Link Library' = get_dsp_head_dynalib
# $app_statlib_stg  = 'Static Library'       = get_dsp_head_slib
my $help = <<EOF;
$pgmname [OPTIONS] input_file
The 'input file' can be either a single 'vcproj' file, of a 'sln' file.
OPTIONS:
 -? or -h        - This brief help.
 -cmp            - If an existing DSP file, compare NEW and OLD.
 -dsp=dsp_dir    - Write DSP file(s) to this directory. (def=$out_dsp_dir).
 -in=in_file     - Alternative to set input file.
 -ll             - Load LOG at end.
 -fix-rel        - Fix relative paths, if an output directory, relative to source, given.
 -svc-dbg=<num>  - Set this debug item in the scanvc.pl module.
 -type=TYPE      - Override project type. TYPES = [CA|WA|DLL|SL] only.
                   CA=Console App, WA=Windows App, DLL=Dynamic-Link, Lib SL=Static Library.
If a solution file (*.sln) is given, then all the project files if contains (*.vcproj) will
first be extracted, and then processed one-by-one.
EOF

sub give_help() {
    prt( $help );
}

sub prtw($) {
    my ($tx) = shift;
    $tx =~ s/\n$//;
    prt("$tx\n");
    push(@warnings,$tx);
}

sub show_warnings() {
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS ...\n" );
        foreach my $line (@warnings) {
            prt("$line\n" );
        }
        prt("\n");
    } else {
        prt("\nNo warnings issued.\n\n");
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    show_warnings();
    #my $dbs = fgs_get_dbg_stg();
    my $dbs = svc_get_dbg_stg();
    if (length($dbs)) {
        prt("WARNING: Debug is ON for [$dbs], in fgscanvc03.pl\n" );
    }
    $dbs = get_sl_debug_stg();
    if (length($dbs)) {
        prt("WARNING: Debug is ON for [$dbs], in $pgmname\n" );
    } else {
        prt("Appears no DEBUG item remain on...\n");
    }
    if (length($msg)) {
        $msg .= "\n" if ( !($msg =~ /\n$/) );
        prt($msg);
    }
    close_log($outfile,$load_log);
    # unlink($outfile);   # delete output file
    exit($val);
}

sub is_c_source_ext($) {
    my ($fil) = shift;
    my ($nm, $dir, $ext) = fileparse( $fil, qr/\.[^.]*/ );
    my $lce = lc($ext);
    return 1 if (($lce eq '.c') || ($lce eq '.cxx') || ($lce eq '.cpp') || ($lce eq '.cc'));
    return 1 if ($lce eq '.fl');    # 2010-05-31 - added for FLTK projects
    return 0;
}

sub is_sln_ext($) {
    my ($fil) = shift;
    my ($nm, $dir, $ext) = fileparse( $fil, qr/\.[^.]*/ );
    my $lce = lc($ext);
    if ($lce eq '.sln') {
        return 1;
    }
    return 0;
}

sub is_vcproj_ext($) {
    my ($fil) = shift;
    my ($nm, $dir, $ext) = fileparse( $fil, qr/\.[^.]*/ );
    my $lce = lc($ext);
    return 1 if ($lce eq '.vcproj');
    return 1 if ($lce eq '.vcxproj');   # 24/11/2010 VC10 support
    return 0;
}

# ===================================================================
#  -NEW_INCS- = [/I "." /I "..\include"], and
#  -NEW_DEFS- = [/D "NDEBUG"... ]
# Maybe could -
# (a) ensure a certain /I "somepath", exists, adding it if NOT
# (b) adjust certain /I "..\path.x64" to a different /I "..\new\path"
# (c) delete duplicates
# (d) etc
# ===================================================================
# reduce the noise...
my $prev_inc_warn = '';
my $prev_def_warn = '';
my $prev_inc_added = '';
my $prev_def_added = '';
my $prev_sdk_added = '';
my $prev_alut_added = '';
my $prev_item_dump1 = '';
my $prev_item_dump2 = '';
sub get_new_inc_hash($$$$$$) {
    my ($v,$rok,$rp,$vcd,$outd,$ky) = @_;
    my $len = length($v);
    my %hash = ();
    my %dupes = ();
    my ($i,$ch,$nc,$tag,$val,$pc,$ra,$nval,$i2,$qt);
    my ($fp,$np,$had_al,$inc_tag,$had_crt,$def_tag,$had_alu,$had_dot,$had_cfg);
    # process the line, char by char...
    $had_al = 0;
    $had_alu = 0;
    $inc_tag = '';
    $had_crt = 0;
    $def_tag = '';
    $had_dot = 0;
    $had_cfg = 0;
    $ch = '';
    for ($i = 0; $i < $len; $i++) {
        $i2 = $i + 1;
        $pc = $ch;  # keep PREVIOUS char
        $ch = substr($v,$i,1);
        $nc = ($i2 < $len) ? substr($v,$i2,1) : '';
        if ( (($ch eq '/')||($ch eq '-')) && (length($nc)) ) {
            $tag = $ch; # begin a SWITCH item
            $i++;   # bump to NEXT char
            for (; $i < $len; $i++) {
                $pc = $ch;  # keep PREVIOUS char
                $ch = substr($v,$i,1);
                $nc = ($i2 < $len) ? substr($v,$i2,1) : '';
                last if ($ch eq '"');   # found first QUOTE
                last if ($ch =~ /\s/);  # or found a SPACE
                $tag .= $ch;
            }
            if ($ch =~ /\s/) {  # if a SPACE, get to NEXT sig char
                $i++;   
                for (; $i < $len; $i++) {
                    $pc = $ch;  # keep PREVIOUS char
                    $ch = substr($v,$i,1);
                    last if ($ch eq '"');
                    last if ( !($ch =~ /\s/) );
                }
            }
            $qt = '';   # assume NO 'quote'
            $val = $ch; # start of a VALUE
            $i2 = $i + 1;
            if ($i2 < $len) {
                if ( $ch eq '"' ) {
                    $i++;   # ok, do have QUOTED text
                    $qt = $ch;  # keep 'quote'
                    $pc = $ch;  # keep PREVIOUS char
                    $ch = substr($v,$i,1);  # and get NEXT char
                    $val .= $ch;    # add to collected value
                }
            } else {
                ${$rok} = 0;
                prtw("WARNING:1:$active_project: Ran out of char! With [$v] FAILED!\n");
                return \%hash;
            }
            $i++;
            if (length($qt)) {
                # process until next 'quote' found, 2010-08-04 but NOT escaped with '\'
                for (; $i < $len; $i++) {
                    $pc = $ch;  # keep PREVIOUS char
                    $ch = substr($v,$i,1);
                    $val .= $ch;
                    last if ( ($ch eq $qt) && ($pc ne "\\") );
                }
            } else {
                # or process until a space found
                for (; $i < $len; $i++) {
                    $pc = $ch;  # keep PREVIOUS char
                    $ch = substr($v,$i,1);
                    last if ($ch =~ /\s/);
                    $val .= $ch;
                }
            }
            # we have (/|-)$tag ["]$val["]
            # ============================
            $nval = strip_quotes($val);
            if ($nval eq '.') {
                # this stays as is
                $had_dot = 1;
            } elsif ($tag =~ /^(-|\/)I$/) {
                # its a /I "path" type - need new relative item?
                prtw("WARNING:$active_project: Multiple I tags. Got [$inc_tag], NOW [$tag]! CHECK THIS\n") if (length($inc_tag) && ($tag ne $inc_tag));
                $inc_tag = $tag;
                $fp = $vcd;
                # ====================================================================
                $had_al = 1 if ($nval =~ /OpenAL/i);   # if got an OpenAL (AL/al.h) include
                $had_alu = 1 if ($nval =~ /alut/);
                $nval =~ s/SimGear\.cs/simgear-cs/i;   # SPECIAL FIX Fred vs Geoff
                $nval =~ s/3rdParty\.x64/3rdParty/i;   # SPECIAL FIX Fred vs Geoff
                $nval =~ s/install(\\|\/)msvc90(\\|\/)OpenSceneGraph/OpenSceneGraph/i;   # SPECIAL FIX Fred vs Geoff
                $nval =~ s/install(\\|\/)msvc90-64(\\|\/)OpenSceneGraph/OpenSceneGraph/i;   # SPECIAL FIX Fred vs Geoff
                $nval =~ s/install(\\|\/)msvc71(\\|\/)OpenSceneGraph/OpenSceneGraph/i;   # SPECIAL FIX Fred vs Geoff
                # ====================================================================
                $fp .= "\\" if ( !( ($fp =~ /(\\|\/)$/) || ($nval =~ /^(\\|\/)/) ) );
                $fp .= $nval;   # get the FULL (relative) path
                $fp = fix_rel_path3($fp,'get_new_inc_hash');
                $np = get_rel_dos_path($fp,$outd);
                $np =~ s/(\\|\/)$//;
                $val = add_quotes($np);
            } elsif ($tag =~ /^(-|\/)D$/) {
                prtw("WARNING:$active_project: Multiple D tags. Got [$def_tag], NOW [$tag]! CHECK THIS\n") if (length($def_tag) && ($tag ne $def_tag));
                $def_tag = $tag;
                $had_crt = 1 if ($nval =~ /_CRT_SECURE_NO_WARNINGS/);
                $had_cfg = 1 if ($nval eq 'HAVE_CONFIG_H');
                if ($nval =~ /^DEFAULT_USGS_MAPFILE/) {
                    prt("$active_project: SPECIAL FIX: Dumping tag [$tag $val]\n") if ($prev_item_dump1 ne $active_project);
                    $prev_item_dump1 = $active_project;
                    ${$rok}++;
                    next;
                }
                if ($nval =~ /^DEFAULT_PRIORITIES_FILE/) {
                    prt("$active_project: SPECIAL FIX: Dumping tag [$tag $val]\n") if ($prev_item_dump2 ne $active_project);
                    $prev_item_dump2 = $active_project;
                    ${$rok}++;
                    next;
                }
            }
            if (defined $dupes{$val}) {
                prtw("WARNING:$active_project:SPECIAL FIX: Avoided duplicate [$val]\n");
            } else {
                $hash{$tag} = [] if (!defined $hash{$tag});
                $ra = $hash{$tag};
                push(@{$ra},$val);  # store item in HASH
                $dupes{$val} = 1;
            }
            ${$rok}++;
        } elsif (($ch eq '/')||($ch eq '-')) {
            prtw("WARNING:2:$active_project: Ran out of char! With [$v] FAILED!\n");
            ${$rok} = 0;
            return \%hash;
        } else {
            if ($ch =~ /\s/) {
                # forget spaces - just continue
            } else {
                prtw("WARNING:3:$active_project: Not A SWITCH! Got [$ch]? With [$v] FAILED!\n");
                ${$rok} = 0;
                return \%hash;
            }
       }
    } # char by char for the whole string

    # =========================
    # Other SPECIAL FIX items
    # =========================
    # -NEW_INCS-
    if ( (length($inc_tag) > 0) && (defined $hash{$inc_tag}) ) {
        $ra = $hash{$inc_tag};
        if ($active_project =~ /simgear/i) {
            prt("SPECIAL FIX: for [$active_project]\n");
            if ( !$had_al ) {
                $val = '"C:\Program Files\OpenAL 1.1 SDK\include"';
                push(@{$ra},$val);  # store item in HASH
                prt("SPECIAL FIX: Added OpenAL SDK include [$val]\n") if ($active_project ne $prev_sdk_added);
                $prev_sdk_added = $active_project;
                ${$rok}++;
            }
            if ( !$had_alu) {
                $val = '"..\..\..\alut\include"';
                push(@{$ra},$val);  # store item in HASH
                prt("$active_project:SPECIAL FIX: Added alut include [$val]\n") if ($active_project ne $prev_alut_added);
                $prev_alut_added = $active_project;
                ${$rok}++;
            }
        }
        if (!$had_dot) {
            $val = '"."';
            push(@{$ra},$val);  # store item in HASH
            prt("$active_project:SPECIAL FIX: Added [/I $val]\n") if ($active_project ne $prev_inc_added);
            $prev_inc_added = $active_project;
            ${$rok}++;
        }
    } elsif ($ky eq '-NEW_INCS-') {
        prtw("WARNING:$active_project: Potential SPECIAL FIXES missed for $ky! No /I tag in [$v]???\n") if ($active_project ne $prev_inc_warn);
        $prev_inc_warn = $active_project;
    }

    # -NEW_DEFS-
    if ( (length($def_tag) > 0) && (defined $hash{$def_tag}) ) {
        $ra = $hash{$def_tag};
        if ( ! $had_crt ) { 
            $val = '"_CRT_SECURE_NO_WARNINGS"';
            push(@{$ra},$val);  # store item in HASH
            prt("$active_project:SPECIAL FIX: Added CRT [$val]\n");
            ${$rok}++;
        }
        if ( ! $had_cfg ) {
            $val = '"HAVE_CONFIG_H"';
            push(@{$ra},$val);  # store item in HASH
            prt("$active_project:SPECIAL FIX: Added CONFIG [$val]\n") if ($prev_def_added ne $active_project);
            $prev_def_added = $active_project;
            ${$rok}++;
        }
    } elsif ($ky eq '-NEW_DEFS-') {
        prtw("WARNING:$active_project: Potential SPECIAL FIXES missed for $ky! No /D tag in [$v]???\n") if ($active_project ne $prev_def_warn);
        $prev_def_warn = $active_project;
    }

    return \%hash;  # return hash{$tag} = [$val,[$val]]
}

# could have 
#   -NEW_POST- = [# Begin Special Build Tool
#SOURCE="$(InputPath)"
#PostBuild_Desc=
#PostBuild_Cmds=if not exist ..\..\..\..\lib md ..\..\..\..\lib	copy "$(TargetDir)GLUT32.LIB" ..\..\..\..\lib	copy "$(TargetDir)GLUT32.DLL" ..\..\..\..\lib	if exist ..\..\..\..\progs\demos copy "$(TargetDir)GLUT32.DLL" ..\..\..\..\progs\demos
## End Special Build Tool
# that needs ADJUSTING - wow
sub get_new_post_string($$$$$)  {   # $v2,\$ok,$rp,$vcd,$outd);
    my ($v,$rok,$rp,$vcd,$outd) = @_;
    my $len = length($v);
    my $nv = $v;
    my $chg = 0;
    my (@arr,$k,$l1,$itm,$chg1,$chg2,$i,$j,$c,$c2,@a2,@a3,$cmd,$l2,$l3,$np,$rd,$frp);
    if ($len) {
        @arr = split("\n",$v);
        $l1 = scalar @arr;
        for ($k = 0; $k < $l1; $k++) {
            $itm = $arr[$k];
            if ($itm =~ /^PostBuild_Cmds=(.+)$/) {
                $cmd = $1;
                @a2 = split("\t",$cmd);
                $l2 = scalar @a2;
                $chg2 = 0;
                for ($i = 0; $i < $l2; $i++) {
                    $c = $a2[$i];
                    if ($c =~ /\.\./) {
                        prt("[dbg_sl_12] Needs adjustment [$c]\n") if ($dbg_sl_12);
                        @a3 = split(/\s/,$c);
                        $l3 = scalar @a3;
                        $chg1 = 0;
                        for ($j = 0; $j < $l3; $j++) {
                            $c2 = $a3[$j];
                            if ($c2 =~ /\.\./) {
                                $rd = $vcd.$c2;
                                $frp = fix_rel_path3($rd,'get_new_post_string');
                                $np = get_rel_dos_path($frp,$outd);
                                $np =~ s/(\\|\/)$//;
                                prt("REL [$rd]\nnew [$frp]\n") if ($dbg_sl_12);
                                prt(" This one [$c2] to [$np]?\n") if ($dbg_sl_12);
                                if ($np ne $c2) {
                                    $a3[$j] = $np;
                                    $chg1++;
                                }
                            }
                        }
                        if ($chg1) {
                            $np = '';
                            foreach $c2 (@a3) {
                                $np .= ' ' if (length($np));
                                $np .= $c2;
                            }
                            $a2[$i] = $np;
                            $chg2++;
                        }
                    }
                }
                if ($chg2) {
                    $rd = '';
                    foreach $c (@a2) {
                        $rd .= "\t" if (length($rd));
                        $rd .= $c;
                    }
                    $arr[$k] = $rd;
                    $chg++;
                    prt("old [$cmd]\nnew [$rd]\n") if ($dbg_sl_12);
                }
            }
        }
        if ($chg) {
            $nv = '';
            foreach $itm (@arr) {
                $nv .= "\n" if (length($nv));
                $nv .= $itm;
            }
            if ($v ne $nv) {
                prt("old [$v]\nnew [$nv]\n") if ($dbg_sl_12);
                ${$rok} = 1;
            }
        }

        prt("rel=[$rp], vcd=[$vcd], od=[$outd]\n") if ($dbg_sl_12);
        #pgm_exit(1,"TEMP EXIT");
    }
    return $nv;
}

# check input libraries to link with
# $v = current value
# $rok = ref to set if changed
# $rp = get_rel_dos_path($vcd,$outd); # changing the PATH
# $vcd = directory of the vcproj file
# $outd = output directory
# can add, substrct, change list
# eg
# [ul_d.lib sg_d.lib zlibd.lib gdal_id.lib /libpath:"..\..\..\..\plib" /libpath:"..\..\..\..\3rdParty\lib"]
# needs to be changed to
# [ul_d.lib sg_d.lib zlibd.lib gdal_id.lib /libpath:"..\..\..\plib" /libpath:"..\..\..\3rdParty\lib"]

sub get_new_libs_string($$$$$)  {   # $v2,\$ok,$rp,$vcd,$outd);
    my ($v,$rok,$rp,$vcd,$outd) = @_;
    my $len = length($v);
    my $nv = $v;
    my $chg = 0;
    #prt("get_new_libs_string: from [$v]\n");
    my @arr = space_split($v);  # split on space, but honor inside inverted commas
    my ($itm,$dir,$fp,$tmp,$rdd,$nitm);
    my @narr = ();
    foreach $itm (@arr) {
        if ($itm =~ /^\/libpath:/) {
            $dir = strip_quotes(substr($itm,9));
            $fp = $vcd;
            $fp .= "\\" if ( !($fp =~ /(\/|\\)$/) );
            $fp .= $dir;
            $tmp = fix_rel_path3($fp,'get_new_libs_string');
            # my $out_dsp_dir = $perl_base;   # this can be changed by -dsp=<new_dir>
            # my $g_had_dsp = 0;  # if given an OUTPUT DSP directory
            $rdd = get_rel_dos_path($tmp,$out_dsp_dir); # changing the PATH
            $rdd =~ s/\\$//;
            $nitm = '/libpath:'.add_quotes($rdd);
            push(@narr,$nitm);
            #prt("Changed\nfrom [$itm]\nto   [$nitm]\n");
            ###pgm_exit(1,"CHECK ME");
            $chg++;
        } else {
            push(@narr,$itm);
        }
    }
    if ($chg) {
        $nv = '';
        foreach $itm (@narr) {
            $nv .= ' ' if (length($nv));
            $nv .= $itm;
        }
        ${$rok} = $chg;
    }
    return $nv;
}

sub Get_Default_Group($) {
    my ($src) = @_;
    my ($grp,$flt);
    if (is_c_source_extended($src)) {
        $grp = get_def_src_grp();
        $flt = get_def_src_filt();
    } elsif (is_h_source_extended($src)) {
        $grp = get_def_hdr_grp();
        $flt = get_def_hdr_filt();
    } elsif (is_resource_file($src)) {
        $grp = get_def_rcs_grp();
        $flt = get_def_rcs_filt();
    } else {
        $grp = "Other Files";
        $flt = '';
    }
    return $grp,$flt;
}

# ======================================================================================
# ok, need to change sources from perhaps '.\src.cxx' to '..\..\lib\src.cxx' - a big job
# and LOTS of other things...
# ======================================================================================
my $prev_src_fix = '';
sub chk_relative_paths($$$) {
    my ($rh,$outd,$vcd) = @_;
    my ($key,$val,$acnt,$i,$src,$grp,$flt,$rp);
    my ($i2,$rsb,@karr,$scnt,$msg,$ky,$v2,$rih,$ok);
    my ($k3,$v3,$v,$nv,$tmp,$tmp2);
    $rp = get_rel_dos_path($vcd,$outd); # changing the PATH
    ##my $rp2 = get_rel_dos_path($outd,$vcd); # how to get from where we were to now out directory
    # this would be used to move say 'windows\VC8\mesa\mesa.dsp' to windows\MSVC
    prt("[dbg_sl_07] Check relative vcd=[$vcd], out=[$outd]\n") if ($dbg_sl_07);
    prt("chk_relative_paths: [$rp],\n from vcd=[$vcd],\n target  =[$outd]\n");

    $key = 'PROJECT_NAME';
    if (! defined ${$rh}{$key}) {
        pgm_exit(1,"INTENRAL ERROR: HAS WITH PROJECT_NAME! Can NOT exit!");
    }
    $active_project = ${$rh}{$key};

    foreach $key (keys %{$rh}) {
        $val = ${$rh}{$key};
        if ( $key =~ /^CURR_/ ) {
            # ignore these CURRENT state items
        } else {
            if ($key eq 'PROJECT_SRCS') {
                $acnt = scalar @{$val};
                prt("$key - $acnt sources to fix path...\n");
                for ($i = 0; $i < $acnt; $i++) {
                    $src = ${$val}[$i][0];
                    $grp = ${$val}[$i][1];
                    $flt = ${$val}[$i][2];
                    # SPECIAL FIX - Fred vs Geoff
                    if ($active_project =~ /simgear/i) {
                        ($grp,$flt) = Get_Default_Group($src);
                        ${$val}[$i][1] = $grp;
                        ${$val}[$i][2] = $flt;
                        prt("SPECIAL FIX for [$active_project] [$src] [$grp] [$flt]\n") if ($prev_src_fix ne $active_project);
                        $prev_src_fix = $active_project;
                    }
                    $src =~ s/^\.(\\|\/)//;
                    #$nv = $rp.$src;
                    $tmp = $vcd.$src;
                    $tmp2 = fix_rel_path3($tmp,'chk_relative_paths');
                    $ok = 'NF';
                    $ok = 'ok' if (-f $tmp2);
                    my ($fnm,$fdir) = fileparse($tmp2);
                    $nv = get_rel_dos_path($fdir,$outd);
                    # 2010/05/06 - why ??? $nv =~ s/(\\|\/)$//;
                    $nv .= "\\" if (length($nv) && !($nv =~ /(\\|\/)$/));
                    $nv .= $fnm;    # add back the file name
                    if ($nv eq $src) {
                        prt("Source [$src] not changed. [$grp] [$flt]\n") if ($dbg_sl_09);
                    } else {
                        prt("Was [$src] GOT CHANGE...\nint [$tmp2] $ok\nNew [$nv] [$grp] [$flt]\n") if ($dbg_sl_09);
                        ${$val}[$i][0] = $nv;
                    }
                }
            } elsif ($key eq 'PROJECT_CFGS') {
                # my $rcfgs = ${$rh}{'PROJECT_CFGS'};
                #                   0       1      2      3
                # push(@{$rcfgs}, [ $pname, $var1, $conf, $dsp_sub_sub ]);
                #  -NEW_INCS- = [/I "." /I "..\include"]
                $acnt = scalar @{$val};
                prt("$key - $acnt configs...\n");
                for ($i = 0; $i < $acnt; $i++) {
                    $i2 = $i + 1;
                    $src = ${$val}[$i][0];
                    $grp = ${$val}[$i][1];
                    $flt = ${$val}[$i][2];
                    $rsb = ${$val}[$i][3];
                    @karr = keys(%{$rsb});
                    $scnt = scalar @karr;
                    $msg = sprintf("%3d:",$i2);
                    # prt( "$msg: [$src] [$grp] [$flt] = $scnt\n" );
                    prt( "$msg: [$src] [$flt] = $scnt config items\n" );
                    foreach $ky (@karr) {
                        $v2 = ${$rsb}{$ky};
                        ###prt("Doing [$ky], value [$v2]\n");
                        $nv = '';
                        if (($ky eq '-NEW_INCS-')||($ky eq '-NEW_DEFS-')) {
                            # also need to fix things like '/I "..\include"', but NOT '/I "."'
                            $ok = 0;
                            $rih = get_new_inc_hash($v2,\$ok,$rp,$vcd,$outd,$ky);
                            if ($ok) {
                                prt(" = $ky = [") if ($dbg_sl_10);
                                $nv = '';
                                foreach $k3 (keys %{$rih}) {
                                    $v3 = ${$rih}{$k3};
                                    foreach $v (@{$v3}) {
                                        $nv .= ' ' if (length($nv));
                                        $nv .= "$k3 $v";
                                    }
                                }
                                if ($nv eq $v2) {
                                    prt(" [$nv] NO CHANGE\n") if ($dbg_sl_10);
                                } else {
                                    prt("\nnew [$nv], \nwas [$v2]\n") if ($dbg_sl_10);
                                    ${$rsb}{$ky} = $nv;
                                    #${$val}[$i][3] = $rsb;
                                }
                            } else {
                                prt( "  $ky = [$v2] FAILED REF\n" );
                            }
                        } elsif ($ky eq '-NEW_POST-') {
                            # could have 
                            #   -NEW_POST- = [# Begin Special Build Tool
                            #SOURCE="$(InputPath)"
                            #PostBuild_Desc=
                            #PostBuild_Cmds=if not exist ..\..\..\..\lib md ..\..\..\..\lib	copy "$(TargetDir)GLUT32.LIB" ..\..\..\..\lib	copy "$(TargetDir)GLUT32.DLL" ..\..\..\..\lib	if exist ..\..\..\..\progs\demos copy "$(TargetDir)GLUT32.DLL" ..\..\..\..\progs\demos
                            ## End Special Build Tool
                            # that needs ADJUSTING - wow
                            $ok = 0;
                            $nv = get_new_post_string($v2,\$ok,$rp,$vcd,$outd);
                            if ($ok) {
                                prt( "  $ky CHANGED ok\nwas [$v2]\nnew [$nv]\n") if ($dbg_sl_11);
                                ${$rsb}{$ky} = $nv;
                            } else {
                                prt( "  $ky = [$v2] NO CHANGES\n" ) if ($dbg_sl_11);
                            }
                        } elsif ($ky eq '-NEW_OUTD-') {
                            $nv = strip_quotes($v2);
                            $nv =~ s/^\.\.\\//;
                            $nv .= "\\" if (!($nv =~ /(\\|\/)$/));
                            $nv .= $active_project;
                            $nv = add_quotes($nv);
                            prt( "  $ky CHANGED ok\nwas [$v2]\nnew [$nv]\n") if ($dbg_sl_11);
                            ${$rsb}{$ky} = $nv;
                        } elsif ($ky eq '-NEW_INTER-') {
                            $nv = strip_quotes($v2);
                            $nv =~ s/^\.\.\\//;
                            $nv .= "\\" if (!($nv =~ /(\\|\/)$/));
                            $nv .= $active_project;
                            $nv = add_quotes($nv);
                            prt( "  $ky CHANGED ok\nwas [$v2]\nnew [$nv]\n") if ($dbg_sl_11);
                            ${$rsb}{$ky} = $nv;
                        } elsif ($ky eq '-NEW_LIBS-') {
                            $nv = strip_quotes($v2);
                            $ok = 0;
                            $nv = get_new_libs_string($v2,\$ok,$rp,$vcd,$outd);
                            if ($ok) {
                                prt( "  $ky CHANGED ok\nwas [$v2]\nnew [$nv]\n") if ($dbg_sl_11);
                                ${$rsb}{$ky} = $nv;
                            } else {
                                prt( "  $ky = [$v2] NO CHANGES\n" ) if ($dbg_sl_11);
                            }
                        } else {
                            prt( "  $ky = [$v2] NOT CHANGED\n" ) if ($dbg_sl_08);
                        }
                        ###prt( "NEXT KEY after $ky [$v2] [$nv]\n");
                    }
                }
            } else {
                # dealt with 'PROJECT_SRCS' and 'PROJECT_CFGS' above
                # What about PROJECT_NAME, PROJECT_CCNT, PROJECT_FDIR, PROJECT_FILE
                # PROJECT_TYPE, PROJECT_DSPF, PROJECT_VERS, PROJECT_APTP, PROJECT_FLAG, PROJECT_MSCV?
                $tmp = '';
                if ($key eq 'PROJECT_NAME') {
                    # $tmp = "Like change name from [$val]?";
                } elsif ($key eq 'PROJECT_CCNT') {
                    # $tmp = "Like config count [$val]?";
                } elsif ($key eq 'PROJECT_FDIR') {
                    # $tmp = "Like FDIR [$val]?";
                } elsif ($key eq 'PROJECT_FILE') {
                    # $tmp = "Like FILE [$val]?";
                } elsif ($key eq 'PROJECT_TYPE') {
                    $tmp = "Like TYPE [$val]?";
                } elsif ($key eq 'PROJECT_DSPF') {
                    $tmp = "Like DSP FILE [$val]?";
                } elsif ($key eq 'PROJECT_VERS') {
                    # $tmp = "Like VERS [$val]?";
                } elsif ($key eq 'PROJECT_APTP') {
                    $tmp = "Like APTP [$val]?";
                } elsif ($key eq 'PROJECT_FLAG') {
                    # $tmp = "Like FLAG [$val]?";
                } elsif ($key eq 'PROJECT_MSCV') {
                    # $tmp = "Like FLAG [$val]?";
                } else {
                    $tmp = "Like UNCASED [$val]?";
                    pgm_exit(1,"CHECKME:chk_relative_paths: key [$key] UNCASED, with val [$val]");
                }
                prt("$key ... any items to change? $tmp\n") if (length($tmp) && $dbg_sl_10);
            }
        }
    }
    # pgm_exit(1,"Temp stop to check");
}

# ensure -NEW_LIBS- hash ref does NOT contain LIBS already in default
sub fix_lib_list($) {
    my ($rh) = @_;
    my $key = 'PROJECT_CFGS';
    my $chgd = 0;
    my $def = get_def_lib_list();
    my @a2 = split(/\s/,$def);
    if (defined ${$rh}{$key}) {
        my $val = ${$rh}{$key};
        my $k2 = '-NEW_LIBS-';
        my $acnt = scalar @{$val};
        for (my $i = 0; $i < $acnt; $i++) {
            my $rsb = ${$val}[$i][3];   # get -NEW_LIBS- hash ref
            if (defined ${$rsb}{$k2}) {
                my $v2 = ${$rsb}{$k2};
                prt("[dbg_sl_13]  [$v2],\nwith default [$def]\n") if ($dbg_sl_13);
                my @a1 = split(/\s/,$v2);
                my $chg = 0;
                my @arr = ();
                my ($lib, $lib2,$fnd,$lclib);
                foreach $lib (@a1) {
                    $lclib = lc($lib);
                    if ($lib =~ /^\/libpath:/i) {  # no change in these
                        push(@arr,$lib);
                    } else {
                        $fnd = 0;   # else check if already in DEFAULTS
                        foreach $lib2 (@a2) {
                            if ($lclib eq lc($lib2)) {
                                $fnd = 1;
                                last;
                            }
                        }
                        if ($fnd) {
                            $chg++; # dump this DUPLICATE
                        } else {
                            push(@arr,$lib);    # else keep this
                        }
                    }
                }
                if ($chg) {
                    $lib = join(" ",@arr);
                    ${$rsb}{$k2} = $lib;
                    prt(" Set NEW [$lib]\n") if ($dbg_sl_13);
                    $chgd++;
                }
            }
        }   # for each configuration
        if ($chgd) {
           # pgm_exit(1,"TEMP EXIT");
        }
    }
}

# dbg_show_entering_files();
# dbg_show_source_files();
# dbg_show_output_files(); # { $dbg_v21 = 1; $dbg_v24 = 1; }
# 2009/10/29 - make it work for TWO different forms of VC HASH
sub process_vcproj_file($$) {
    my ($in, $outd) = @_;
    my ($key,$tmp,$out,$cnt,$dsp);
    my ($prjf,$nm,$dir,$ext,$dspf);
    my ($msg);
    my ($rdspf,$fprjf,$fdspf,$dprjf);
    prt( "[dbg_sl_05] $pgmname: Scanning [$in]...\n" ) if ($dbg_sl_05);
    my ($vc_name,$vc_dir) = fileparse($in);
    $vc_dir = $pwd."\\" if ($vc_dir =~ /^\.(\\|\/)$/);
    my $rh = process_VCPROJ3($in);

    # check for application type over-ride...
    if (length($curr_app_type)) {
        $key = 'APP_TYPE';
        $key = 'PROJECT_APTP' if (!defined ${$rh}{$key});
        if (defined ${$rh}{$key}) {
            $tmp = ${$rh}{$key};
            ${$rh}{$key} = $curr_app_type;
            if ($tmp ne $curr_app_type) {
                prt("Overrode $key with [$curr_app_type], from [$tmp]\n");
            }
        }
    }

    # 2010-01-15 - get appropriate DSP file name (real = to replace existing, if any)
    $key = 'PROJECT_FILE';
    $fprjf = '';
    $rdspf = '';
    $fdspf = '';
    if (defined ${$rh}{$key}) {
        $fprjf = ${$rh}{$key};
        ($nm,$dprjf,$ext) = fileparse($fprjf, qr/\.[^.]*/);
        $fdspf = $dprjf.$nm.".dsp";   # this may/should be ABSOLUTE
    } else {
        pgm_exit(1,"ERROR: key [$key] NOT IN hash! AND IT MUST BE!! Aborting!!!\n");
    }

    # show_hash_results3($rh) if ($dbg_sl_04);  # this would be BEFORE any changes made in chk_relative_paths...

    $key = '-NEW_PROJECT_NAME-';
    $key = 'PROJECT_NAME' if (!defined ${$rh}{$key});
    if ( $write_dsp && (defined ${$rh}{$key}) ) {
        $tmp = ${$rh}{$key};    # get the PROJECT NAME
        $dsp = $tmp.".dsp";     # make a DSP file name
        ${$rh}{'PROJECT_DSPF'} = $dsp;
        $outd .= "\\" if ( !($outd =~ /[\\\/]$/) ); # ensure out directory ends '\'
        $out = $outd;           # using OUT directory
        $out .= "temp.".$dsp;   # form a TEMPORARY DSP file name

        fix_lib_list($rh);
        # crude game to ensure TEMP DSP name for this project is UNIQUE
        $cnt = 0;
        while ( is_in_array($out, @dsp_file_list) ) {
            $cnt++; # already have a DSP of that name, so
            $out = $outd;   # get OUT directory again, and
            $out .= "temp.".$tmp.$cnt.".dsp";   # add a COUNT to name
        }

        if ($fix_rel_paths) {
            # ======================================================================================
            # ok, need to change sources from perhaps '.\src.cxx' to '..\..\lib\src.cxx' - a big job
            # and LOTS of other things...
            # UGH - calling this HERE, is BEFORE the %results has is built
            chk_relative_paths($rh,$outd,$vc_dir);  # was $perl_base; # this can be changed by -dsp=<new_dir>
            # ======================================================================================
        } else {
            prt("No relative path change: vcd=[$vc_dir] out=[$outd]\n");
        }

        show_hash_results3($rh) if ($dbg_sl_04);

        # *** WRITE DSP FILE - FIRST TO A 'TEMP' FILE, to do a compare, if needed ***
        # ===========================================================================
        if ( write_hash_to_DSP3( $out, $rh, $dbg4write ) ) {
            push(@dsp_file_list,$out);  # store name
            #     project_list    0     1     2
            #push(@project_list, [ $tmp, $dsp, $out ]);
            push(@project_list, [ $tmp, $fdspf, $out ]);
            $key = 'PROJECT_FILE';
            if (defined ${$rh}{$key}) {
                $prjf = ${$rh}{$key};
                prt( "For '$prjf' written '$out'\n" );

                # Uses cmp2dsps[?].pl, external to here...
                if ($comp_2_dsps) {
                    ($nm,$dir,$ext) = fileparse($prjf, qr/\.[^.]*/);
                    $dspf = $dir.$nm.".dsp";
                    if (( -f $dspf)&&( -f $out)) {
                        $msg = "cmp2dsps $dspf $out";
                        $msg .= " -l" if ($load_log);
                        prt("Doing $msg...\n");
                        system("$msg");
                    } else {
                        $msg = "No compare done! ";
                        if ( !(-f $dspf) ) {
                            $msg .= "Missing [$dspf]?";
                        }
                        if ( !(-f $out) ) {
                            $msg .= "Missing [$out]??";
                        }
                        prtw("WARNING: $msg\n");
                    }
                }
                # =======================================
            }
        } else {
            prtw("WARNING: No DSP written for [$tmp] project.\n" );
        }
    } else {
        show_hash_results3($rh) if ($dbg_sl_04);
        prtw("WARNING: NO PROJECT NAME! = NO DSP WRITTEN!\n");
    }
    return $rh;
}

sub fix_rel_path2($$) {
    my ($root,$rel) = @_;
    my $cd = cwd();
    my ($fp,$msg,$tmp);
    if (chdir($root)) {
        $fp = File::Spec->rel2abs($rel);    # we are IN the SLN directory, get ABSOLUTE from RELATIVE
        chdir($cd); # and get us back to where we were...
        $msg = "1:File::Spec:";
    } else {
        $fp = fix_rel_path3($root.$rel,'fix_rel_path2'); # else use internal service
        $msg = "2:fix_rel_path3:"
    }
    if (-f $fp) {
        $msg .= " ok";
    } else {
        $msg .= " NOT FOUND";
        if ($fp =~ /\\SimGear\.cs\\/) {
            $tmp = $fp;
            $tmp =~ s/\\SimGear\.cs\\/\\SimGear-cs\\/;
            if (-f $tmp) {
                $fp = $tmp;
                $msg = "ok $msg";
            }
        }
        if ($msg =~ /^1/) {
            $tmp = fix_rel_path3($root.$rel,'fix_rel_path2'); # else use internal service
            if (-f $tmp) {
                $fp = $tmp;
                $msg .= ", but OK with fix_rel_path3!!!";
            } else {
                $msg .= ", NOR from fix_rel_path3 [$tmp]"
            }
        }
    }
    prt("From: [$root] [$rel], got [$fp] $msg\n") if ($dbg_sl_14);
    return $fp; # hopefully, return ABSOLUTE path
}

# Read and store contents of SOLUTION (.sln) file
# 22/04/2008 - Extract DEPENDENCIES from solution file, and add to DSW output
# 24/11/2010 - Support for VC10 XML files
sub process_SLN_file2($) {
	my ($sln_fil_in) = shift;
	my ($cnt, $line, $vers, @arr, $mver, $par, $ff, $itmnum);
	my ($projname, $projfile, $projff, $gotproj, $relpath);
	my ($tnm,$tpth);
	my ($inproj, $tline, $projid, $inpdeps, $projdeps);
    my ($nmdeps, $depid, $pn, $fnd, $list);
    my ($msg,$text,$dspfile,$fdspfil,$name);
    my $fil = File::Spec->rel2abs($sln_fil_in);
	open IF, "<$fil" or mydie( "ERROR: Unable to open [$fil]... $! ...\n" );
	my @lines = <IF>;
	close IF;
	$cnt = scalar @lines;
	($name,$sln_path) = fileparse($fil); # get the NAME, and SOLUTION PATH (should be ABSOLUTE, NOT relative)
    my %hash = ();
    my %sln_projects = ();
    my %sln_projpath = ();
    my %sln_depends = ();
    my %sln_projids = ();
    my %missed_vcprojs = ();
	prt( "\nProcessing $cnt lines ... n=[$name] p=[$sln_path] ...\n" );
	$projname = '';
	$projfile = '';
	$projff = '';
	$gotproj = 0;
	$inproj = 0;
	$inpdeps = 0;
	foreach $line (@lines) {
		$tline = trim_all($line);
		if ($line =~ /.+Format\s+Version\s+(\d+\.\d+)$/i) {
			$vers = $1;	# get n.nn version
			@arr = split(/\./,$vers);
			$mver = $arr[0];
			prt( "Is MSVC Version $mver ...\n" );
		} elsif ($line =~ /^Project\s*\(/) {
			# seek like 
			#Project("{8BC9CEB8-8B4A-11D0-8D11-00A0C91BC942}") = "abyss", "abyss.vcproj", "{8B384B8A-2B72-4DC4-8DF1-E3EF32F18850}"
            #Project("{8BC9CEB8-8B4A-11D0-8D11-00A0C91BC942}") = "fgadmin", "fgadmin\fgadmin.vcxproj", "{7004E589-7EA0-4AFD-B432-3D5E00B55049}"
            #	ProjectSection(ProjectDependencies) = postProject
            #		{22540CD3-D3CA-4C86-A773-80AEEE3ACDED} = {22540CD3-D3CA-4C86-A773-80AEEE3ACDED}
            #	EndProjectSection
            #EndProject
			###prt( "Got project [$line] ...\n" );
			$inproj = 1;
			@arr = split( '=', $line );
			$cnt = scalar @arr;
			if ($cnt == 2) {
				$par = $arr[1]; # get 2nd part, like say '"abyss", "abyss.vcproj", "{8B384B8A-2B72-4DC4-8DF1-E3EF32F18850}"'
				@arr = split(',', $par);
				$cnt = scalar @arr;
				if ($cnt == 3) {
					$projname = strip_quotes(trim_all($arr[0])); # project NAME
					$projfile = strip_quotes(trim_all($arr[1])); # vcproj FILE
					$projid   = strip_quotes(trim_all($arr[2])); # project ID
					$projff   = fix_rel_path2($sln_path,$projfile); # return ABSOLUTE
					# if ((length($projname)) && (is_vcproj_ext($projfile)) && (-f $projff)) {
                    # 01/12/2010 - Remove need for the file to EXIST
					if ((length($projname)) && (is_vcproj_ext($projfile)) ) {
                        if (-f $projff) {
                            # and file
                        } else {
                            $missed_vcprojs{$projname} = $projff;
                        }
						$gotproj = 1;
						($tnm,$tpth,$text) = fileparse($projff,qr/\.[^.]*/);
                        $fdspfil = $tpth.$tnm.".dsp";   # this is a DSP EQUIVALENT to the vcproj location
                        # BUT, we may have been given a DIFFERENT DSP output dir through
                        # -dsp=<dir> ($out_dsp_dir) and $g_had_dsp, and maybe '-fix-rel' ($fix_rel_paths)
                        if ($g_had_dsp) {
                            $fdspfil = $out_dsp_dir;
                            $fdspfil .= "\\" if ( !($fdspfil =~ /(\\|\/)$/) );
                            $fdspfil .= $tnm.".dsp";
                        }
						$relpath = get_rel_dos_path($tpth, $sln_path);
						($tnm,$tpth,$text) = fileparse($projfile,qr/\.[^.]*/);
                        $dspfile = $tpth.$tnm.".dsp";
						prt( "Got PROJECT name=$projname, file=[$projfile], ff=[$projff], rel=[$relpath].\n" ) if ($dbg_sl_01);
						if (defined $sln_projects{$projname}) {
							mydie( "A PROBLEM: Already GOT this project name $projname!!!\n" );
						} else {
							$sln_projects{$projname} = $projff;
							# $sln_projpath{$projname} = $relpath; # can be BLANK, or say 'BvMath/'
                            #                           0         1       2        3        4
							$sln_projpath{$projname} = [$projfile,$projff,$relpath,$dspfile,$fdspfil]; # relative project file, like '..\alut\path\alut.vcproj'
							prt( "Stored \$sln_projpath{$projname} = [0:$projfile,1:$projff,2:$relpath,3:$dspfile,4:$fdspfil]\n") if ($dbg_sl_15);
							$sln_projids{$projname}  = $projid;
							$sln_depends{$projname}  = '';	# start dependencies, if any
                            if ($dbg_sl_16) {
                                my $msg = $projname;
                                $msg .= ' ' while (length($msg) < 24);
                                $msg .= $projid;
                                prt("$msg\n");
                            }
						}
                        ### pgm_exit(1,"TEMP EXIT");
					} else {
						$msg = "WARNING: ";
						if (!length($projname)) {
							$msg .= "Failed to get a project name! ";
						} elsif ( !is_vcproj_ext($projfile) ) {
							$msg .= "Name [$projfile] NOT a VCPROJ name! ";
						} else {
							$msg .= "Unable to locate file [$projff]! ";
						}
						$msg .= " Line is (trimmed)\n$tline";
                        prtw("$msg\n");
					}
				} else {
					prtw( "Warning: Part 2 of Project line did NOT split into 3 on comma!???\n" );
				}
			} else {
				prtw( "Warning: Project line did NOT split in 2 on equal sign!???\n" );
			}

			# to switch on $tryharder requires additional work on parsing this line
			# =====================================================================
			prtw("WARNING: line [$line] ...\n") if (!$gotproj);
			# =====================================================================
		} elsif ($inproj) {
			# in the Project section - look for END of section, and DEPENDENCIES
			# ProjectSection(ProjectDependencies)
			if ($tline eq 'EndProject') {
			###if ($line =~ /^EndProject\s*/)
				$inproj = 0;
			} else {
				if ($inpdeps) {
					if ($tline eq 'EndProjectSection' ) {
						$inpdeps = 0;
					} else {
						# collect dependencies
						@arr = split( '=', $line );
						$cnt = scalar @arr;
						if ($cnt == 2) {
							$arr[0] = trim_all($arr[0]);
							$arr[1] = trim_all($arr[1]);
							if ($arr[0] eq $arr[1]) {
								$projdeps = $sln_depends{$projname};	# extract dependencies, if any
								$projdeps .= '|' if (length($projdeps));
								$projdeps .= $arr[0];
								prt( "$pgmname: Proj $projname, dependant on $arr[0] ...\n" ) if ($dbg_sl_02);
								##prt( "Proj $projname, dependant on $projdeps ...\n" );
								$sln_depends{$projname} = $projdeps;
							} else {
								prtw( "Warning: Found different IDS '$arr[0]' NE '$arr[1]'!!! \n" );
							}
						} else {
							prtw( "Warning: Project DEPENDENCY line did NOT split in 2 on equal sign!???\n" );
							prtw( "line=$line" );
						}
					}
				} elsif ($line =~ /ProjectSection\s*\(\s*ProjectDependencies\s*\)/) {
					$inpdeps = 1;
				}
			}
		}
	}
	###prt( "Done $fil ... got ".scalar @proj_files." project files ...\n" );
	prt( "Done $fil ... got ".scalar keys(%sln_projects)." project files ...\n" );
	# resolve dependencies, if possible - warn if NOT ...
	#resolve_depends();
    # Have STORED
    # $sln_projects{$projname} = $projff;
	# $sln_projpath{$projname} = $relpath; # can be BLANK, or say 'BvMath/'
    #                           0         1       2        3        4
	#$sln_projpath{$projname} = [$projfile,$projff,$relpath,$dspfile,$fdspfil]; # relative project file, like '..\alut\path\alut.vcproj'
	#prt( "Stored \$sln_projpath{$projname} = [0:$projfile,1:$projff,2:$relpath,3:$dspfile,4:$fdspfil]\n") if ($dbg_sl_15);
	# $sln_projids{$projname}  = $projid;
	# $sln_depends{$projname}  = '';	# start dependencies, if any
	foreach $projname (keys %sln_projects) {
		$projdeps = $sln_depends{$projname};
		if (length($projdeps)) {
			# there is LENGTH, convert giant CID to simple project names
			@arr = split( /\|/, $projdeps );	# split em up
			$cnt = scalar @arr;	# get count of split
			#prt( "Proj $projname, depends on $cnt = $projdeps ...\n" );
			$nmdeps = '';	# build simple NAME set
			foreach $depid (@arr) {
                # find project MATCHING that ID, in full list of IDs
                $fnd = 0;
                $list = '';
				foreach $pn (keys %sln_projids) {
					if ($pn ne $projname) {
						$projid = $sln_projids{$pn};
                        $list .= "|$projid";
						if ($depid eq $projid) {
							$nmdeps .= '|' if (length($nmdeps));
							$nmdeps .= $pn;
                            $fnd = 1;
							last;
						}
					}
				}
                if (!$fnd) {
                    prtw("Warning: Failed to FIND [$depid], in list \n[$list]\n!");
                }
			}
			@arr = split( /\|/, $nmdeps );
			prt( "$pgmname: proj $projname, depends on $nmdeps ...\n" ) if ($dbg_sl_03);
			if ($cnt != scalar @arr) {	# YEEK - Does NOT match - OH WELL
				prtw( "WARNING: proj [$projname] with depends [$projdeps] Failed to get SAME count $cnt - got ".scalar @arr." on split [$nmdeps]\n" );
                pgm_exit(1,"");
			}
			$sln_depends{$projname} = $nmdeps;
		}
	}
    # ====================================================================
    $hash{'SOLUTION'} = $fil;   # keep the SOLUTION files also
    $hash{'PROJECTS'} = { %sln_projects };
    $hash{'PROJPATH'} = { %sln_projpath };  # array refs [$projfile,$projff,$relpath]
    $hash{'DEPENDS'}  = { %sln_depends  };
    $hash{'PROJIDS'}  = { %sln_projids };
    $hash{'MISSED_FILES'} = { %missed_vcprojs }; # not found on DISK
    return \%hash;
}

sub remove_base_path($$) {
    my ($ln, $bs) = @_;
    my $len1 = length($ln);
    my $len2 = length($bs);
    if ($len1 < $len2) {
        return $ln;
    }
    my ($i,$c1,$c2);
    for ($i = 0; $i < $len2; $i++) {
        $c1 = lc(substr($ln,$i,1));
        $c2 = lc(substr($bs,$i,1));
        if ($c1 ne $c2) {
            return $ln;
        }
    }
    return substr($ln,$len2);
}

sub return_common_dir($$) {
    my ($d1,$d2) = @_;
    my ($ll,$k,$com);
    $com = '';
    $ll = length($d1);
    $ll = length($d2) if (length($d2) < $ll);   # get SHORTEST
    for ($k = 0; $k < $ll; $k++) {  # process for SHORTEST length
        last if (lc(substr($d1,$k,1)) ne lc(substr($d2,$k,1))); # end on first NOT SAME
        $com .= substr($d1,$k,1);   # else add to common
    }
    return $com;
}

sub get_common_dir($) {
    my ($rffh) = @_;
    my $commdir = '';
    my @keys = keys %{$rffh};
    my $kcnt = scalar @keys;
    my ($ky1,$ky2,$k,$com);
    for ($k = 0; ($k+1) < $kcnt; $k++) {
        $ky1 = $keys[$k];
        $ky2 = $keys[$k+1];
        $com = return_common_dir($ky1,$ky2);
        if (length($com) == 0) {
            return "";  # no COMMON
        }
        if (length($commdir)) {
            $com = return_common_dir($com,$commdir);
            if (length($com) == 0) {
                return "";  # no COMMON
            }
        }
        $commdir = $com;    # update the COMMON
    }
    return $commdir;
}

sub show_sln_results($) {
    my ($rsh) = @_;
    my ($cnt,$min1,$min2,$min3,$cnt2);
    my ($val,$val2,$val3,$len);
    my ($k,$i,$dspf,$j);
    my ($tdsp,$vcpf);
    $k = 'RESULTS';
    if (! defined ${$rsh}{$k}) {
        prtw("WARNING: Soluion hash reference does NOT contain [$k]!\n");
        return 1;
    }
    # push(@results, [$k, $nm, $captyp, $ff]); # stored in 'RESULTS'
    my $results = ${$rsh}{$k};

    $k = 'PROJECT_LIST';
    if (! defined ${$rsh}{$k}) {
        prtw("WARNING: Soluion hash reference does NOT contain [$k]!\n");
        return 1;
    }
    my $plist = ${$rsh}{$k};
    $k = 'PROJECT_FILE';
    if (! defined ${$rsh}{$k}) {
        prtw("WARNING: Soluion hash reference does NOT contain [$k]!\n");
        return 1;
    }
    my $in = ${$rsh}{$k};

    $cnt = scalar @{$results};
    # get lengths, for neat output
    $min1 = 0;
    $min2 = 0;
    $min3 = 0;
    #                       0     1     2
    # push(@project_list, [ $tmp, $dsp, $out ]);
    $cnt2 = scalar @{$plist};
    prt( "\nSolution file [$in], has $cnt projects...($cnt2)\n" );
    for ($i = 0; $i < $cnt; $i++) {
        $val = ${$results}[$i][0];
        $val2 = ${$results}[$i][1];
        $val3 = ${$results}[$i][2];
        $len = length($val);
        $min1 = $len if ($len > $min1);
        $len = length($val2);
        $min2 = $len if ($len > $min2);
        $len = length($val3);
        $min3 = $len if ($len > $min3);
    }
    if ($cnt) {
        # about to output something like
        # testcon testcon.vcproj Console Application  testcon.dsp (C:\GTools\perl\temp.testcon.dsp)
        $val = "Name";
        $val2 = "File";
        $val3 = "Type";
        $val .= ' ' while (length($val) < $min1);
        $val2 .= ' ' while (length($val2) < $min2);
        $val3 .= ' ' while (length($val3) < $min3);
        prt("$val $val2 $val3 DSP File\n"); # set HEADINGS
    }
    for ($i = 0; $i < $cnt; $i++) {
        $val = ${$results}[$i][0]; # extract the project NAME
        $dspf = 'UNKNOWN';
        $tdsp = $dspf;
        for ($j = 0; $j < $cnt2; $j++) {
            if (${$plist}[$j][0] eq $val) {
                $dspf = ${$plist}[$j][1];
                $tdsp = ${$plist}[$j][2];
                last;
            }
        }
        $val2 = ${$results}[$i][1];
        $val3 = ${$results}[$i][2];
        #                             0         1       2        3        4
        # $sln_projpath{$projname} = [$projfile,$projff,$relpath,$dspfile,$fdsp]; # relative project file, like '..\alut\path\alut.dsp'
        $vcpf = ${$results}[$i][3]; # destination, relative DSP file, for DSW write
        if ($tdsp ne $dspf) {
            $dspf = "$dspf ($tdsp)";
        }
        $val .= ' ' while (length($val) < $min1);
        $val2 .= ' ' while (length($val2) < $min2);
        $val3 .= ' ' while (length($val3) < $min3);
        #prt("$val $val2 $val3 $dspf\n");
        # tgvpf tgvpf.vcproj Console Application .\tgvpf.dsp (C:\FG\28\terragear-cs\projects\msvc\temp.tgvpf.dsp) [tgvpf\tgvpf.dsp]
        prt("$val $val2 $val3 $dspf [$vcpf]\n");
    }
    prt( "$pgmname: Done $cnt vcproj processing...\n" );
}

sub sln_file_processing($$$) {
    my ($flg,$in,$out) = @_;
    my ($k,$rsh,$val,$ff,$key,$captyp,$nm,$dir,$cnt,$i,$min1,$min2,$val2,$len);
    my ($refhash,$min,$cnt2,$dspf,$j,$val3,$min3,$ok);
    my ($ext,$k2,$relpf,$fdspf);
    my @results = ();
    ($nm,$sln_root_dir) = fileparse($in);
    $rsh = process_SLN_file2($in);
    prt( "$pgmname: KEYS in SLN hash = " );
    foreach $k (keys %{$rsh}) { prt( "$k " ); }
    prt("\n");
    # =====================================
    $k = 'PROJECTS';
    $k2 = 'PROJPATH';
    if ((defined ${$rsh}{$k})&&(defined ${$rsh}{$k2})) {
        # $sln_projects{$projname} = $projff;
        $val = ${$rsh}{$k};     # extract projects HASH
        $val2 = ${$rsh}{$k2};   # extract project paths HASH
        $min = 0;
        $cnt = 0;
        $min1 = 0;
        my %ffhash = ();
        foreach $k (keys %{$val}) {
            $ff = ${$val}{$k};
            $len = length($k);
            $min = $len if ($len > $min);
            if (is_vcproj_ext($ff)) {
                $ffhash{$ff} = 1;
                $cnt++;
            } else {
                $ffhash{$ff} = 0;
            }
            $len = length($ff);
            $min1 = $len if ($len > $min1);
        }
        my $commdir = get_common_dir( \%ffhash );
        prt( "All $cnt vcproj files in a COMMON PATH: [$commdir] sln path=[$sln_root_dir]\n" ) if (length($commdir));
        foreach $k (keys %{$val}) {
            $ff = ${$val}{$k};
            #                             0         1       2        3
            # $sln_projpath{$projname} = [$projfile,$projff,$relpath,$dspfile]; # relative project file, like '..\alut\path\alut.dsp'
            # and later
            # push(@results, [$k, $nm, $captyp, $relpf, $fdspf]); # stored in 'RESULTS'
            $val3 = ${$val2}{$k};
            $relpf = ${$val3}[3];   # relative DSP file, for DSW write
            $ok = (( -f $ff ) ? "ok" : "NOT FOUND!");
        	($nm, $dir, $ext) = fileparse( $ff, qr/\.[^.]*/ );
            $dspf = $dir.$nm.".dsp";
            $ok .= "2" if (-f $dspf);
            #$ff = remove_base_path($ff,$commdir) if (length($commdir));
            $k .= ' ' while (length($k) < $min);
            $ff .= ' ' while (length($ff) < $min1);
            prt("$k - $ff ($ok) $relpf\n" );    # this DSP rel.path may need to be changed later, if -dsp=<path>
        }
        prt( "\nNow to process EACH of the $cnt projects...\n" );
        # --------------------------------------------------
        foreach $k (keys %{$val}) {
            $ff = ${$val}{$k};
            # prt("$k - $ff\n" );
            ($nm, $dir) = fileparse($ff);
            # if (is_vcproj_ext($ff))
            # 01/12/2010 - add an existance check
            if (is_vcproj_ext($ff) && (-f $ff)) {
                $refhash = process_vcproj_file($ff, $out);
                $key = 'APP_TYPE';
                $key = 'PROJECT_APTP' if (!defined ${$refhash}{$key});
                if (defined ${$refhash}{$key}) {
                    $captyp = ${$refhash}{$key};
                } else {
                    $captyp = "Unknown - key=[$key] NOT SET"; 
                }
                #                             0         1       2        3     4
                # $sln_projpath{$projname} = [$projfile,$projff,$relpath,$rdsp,$fdsp]; # relative project file, like '..\alut\path\alut.dsp'
                $val3 = ${$val2}{$k};
                $relpf = ${$val3}[3];   # relative DSP file, for DSW consumption (see write_proj_DSW3)
                $fdspf = ${$val3}[4];
                if ($fix_rel_paths && $g_had_dsp) {
                    my ($tn,$td) = fileparse($relpf);
                    $relpf = ".\\$tn";
                }
                #               0   1    2        3       4
                push(@results, [$k, $nm, $captyp, $relpf, $fdspf]); # stored in 'RESULTS'
            }
        }
    } else {
        pgm_exit(1,"ERROR: key [$k] NOT found in hash!\n");
    }

    $k = 'RESULTS';
    ${$rsh}{$k} = [@results];
    $k = 'PROJECT_LIST';
    ${$rsh}{$k} = [@project_list];  # keep project list, including output DSP file, if written
    $k = 'PROJECT_FILE';
    ${$rsh}{$k} = $in;
    return $rsh;
}

# ==========================================================
# MAIN
############################################################
my $args_ref = parse_args(@ARGV);

foreach $in_file (@{$args_ref}) {
    if (is_vcproj_ext($in_file)) {
        process_vcproj_file($in_file, $out_dsp_dir);
    } elsif (is_sln_ext($in_file)) {
        my $rsh = sln_file_processing(0, $in_file, $out_dsp_dir);
        show_sln_results($rsh);
        if (@project_list) {
            my $out_dsw = $out_dsp_dir."\\temp.$pgmname.DSW";
            # write_proj_DSW3( $out_dsp_dir."\\temp.$pgmname.DSW", \@project_list);
            prt("\nDoing write_proj_DSW3 to [$out_dsw]. Debug=[$debug_dsw_write]\n");
            write_proj_DSW3( $out_dsw, $rsh, $out_bat_file, $debug_dsw_write);
        }
    } else {
        prtw( "WARNING: Unprocessed file extension! [$in_file]!\n" );
    }
}

pgm_exit(0,"Normal exit.");
##########################################################

sub chk_arg {
    my ($arg, @av) = @_;
    fatal( "Invalid $arg - needs value ... -? for help ... aborting!\n" ) if !(@av);
}

sub need_arg {
	my ($a, @b) = @_;
	if (!@b) {
		prt( "Error: $a argument requires additional item! Try -?\n" );
        pgm_exit(1,"COMMAND ERROR");
	}
}

sub parse_args { # @ARGV
    my (@av) = @_;
    my $dn = scalar @av;
    my @inp = ();
    my ($arg,$tmp,$i,$sarg,$val);
    if ($dbg_sl_06) {
        prt( "[dbg01] parsing $dn arguments... " );
        for ($i = 0; $i < $dn; $i++) {
            prt( "[".$av[$i]."]" );
        }
        prt("\n");
    }
    $dn = 0;
    my $had_frp = 0;
	while (@av) {
        $dn++;
		$arg = $av[0];
        prt( "[dbg01] $dn: $arg\n" ) if ($dbg_sl_06);
		if (substr($arg,0,1) eq '-') {
            $sarg = substr($arg,1);
			if (($sarg eq '?')||($sarg eq 'h')||($sarg eq '-help')) {
				give_help();
                pgm_exit(0,"HELP_EXIT");
            } elsif ($arg =~ /^-in=(.+)$/) {
    			$in_file = $1;
                if (-f $in_file) {
                   prt( "Set in file to [$in_file] ...\n" );
                   push(@inp,$in_file);
                } else {
                    prt( "Current Work Directory = [$pwd]\n" );
                    mydie( "ERROR: Can NOT locate IN FILE [$in_file]! check name, location! aborting...\n" );
                }
            } elsif ($arg eq '-l') {
                $load_log = 1;
                prt( "Set in load log at end...\n" );
            } elsif ($arg eq '-in') {
                need_arg($arg,@av);
                shift @av;
                $dn++;
                $arg = $av[0];
                prt("[dbg01] $dn: $arg\n") if ($dbg_sl_06);
    			#$in_file = $arg;
    			$in_file = File::Spec->rel2abs($arg);   # get ABSOLUTE path of input
                if (-f $in_file) {
                   prt( "Set in file to [$in_file] ...\n" );
                   push(@inp,$in_file);
                } else {
                    prt( "Current Work Directory = [$pwd]\n" );
                    pgm_exit(1,"ERROR: Can NOT locate IN FILE [$in_file]! check name, location! aborting...\n" );
                }
            } elsif ($arg eq '-cmp') {
                $comp_2_dsps = 1;
                prt("Set compare NEW and any OLD DSP file.\n");
            } elsif ($arg eq '-debug') {
                set_sl_debug_on();
                svc_set_dbg_on();
                $dbg4write = -1;    # all write DEBUG on
            } elsif ($arg eq '-dsp') {
                need_arg($arg,@av);
                shift @av;
                $dn++;
                $arg = $av[0];
                prt("[dbg01] $dn: $arg\n") if ($dbg_sl_06);
    			$sarg = File::Spec->rel2abs($arg);   # get ABSOLUTE path of input
                prt( "Setting output file to abs=[$sarg] ($arg), from [$out_dsp_dir]...\n" );
                $write_dsp = 1;
                #$out_dsp_dir = $arg;
                $out_dsp_dir = $sarg;
                $g_had_dsp = 1;
            } elsif ($arg =~ /$-dsp=(.+)$/) {
                $tmp = $1;
    			$sarg = File::Spec->rel2abs($tmp);   # get ABSOLUTE path of input
                prt( "Setting output file to abs=[$sarg] ($tmp), from [$out_dsp_dir]...\n" );
                #$out_dsp_dir = $tmp;
                $out_dsp_dir = $sarg;
                $write_dsp = 1;
                $g_had_dsp = 1;
            } elsif ($arg =~ /^-type=(CA|WA|DLL|SL)$/) {
                $tmp = $1;
                if ( get_app_type_4_short($tmp,\$curr_app_type)  && length($curr_app_type) ) {
        			prt( "Set proj type override to [$curr_app_type] ($tmp)...\n" );
                } else {
    				mydie( "ERROR: Unknown option [$arg] ... try -? ... aborting!\n" );
                }
            } elsif (($arg eq '-fix-rel')||($arg eq '-fix_rel')) {
                $fix_rel_paths = 1;
                prt("Set to fix relative paths of sources.\n");
                $had_frp = 1;
            } elsif ($sarg =~ /^svc-dbg=(\d+)/) {
                $val = $1;
                prt("[dbg01] $dn: $arg\n") if ($dbg_sl_06);
                if (svc_set_dbg_item($val,1)) {
                   pgm_exit(1,"ERROR: Unable to set scanvc.pl dbg_v$val... aborting!\n" );
                }
            } elsif ($sarg =~ /^svc-dbg$/) {
                need_arg($arg,@av);
                shift @av;
                $dn++;
                $sarg = $av[0];
                prt("[dbg01] $dn: $arg $sarg\n") if ($dbg_sl_06);
                if ( !($sarg =~ /^\d+$/) || ( svc_set_dbg_item($sarg,1) ) ) {
                   pgm_exit(1,"ERROR: [$arg] [$sarg] Unable to set scanvc.pl dbg_v$sarg... aborting!\n" );
                }
            } elsif ($arg eq '-type') {
                need_arg($arg,@av);
                shift @av;
                $dn++;
                $arg = $av[0];
                prt("[dbg01] $dn: $arg\n") if ($dbg_sl_06);
                if ($arg =~ /^(CA|WA|DLL|SL)$/) {
                    $tmp = $1;
                    if ( get_app_type_4_short($tmp,\$curr_app_type) && length($curr_app_type) ) {
                        prt( "Set proj type override to [$curr_app_type] ($tmp)...\n" );
                    } else {
                        pgm_exit(1,"ERROR: Unknown option [-type $arg] ... try -? ... aborting!\n" );
                    }
                } else {
    				pgm_exit(1,"ERROR: Unknown option [$arg]! Expected one {CA|WA|DLL|SL]!! try -? ... aborting!\n" );
                }
            } elsif ($arg eq '-ll') {
                $load_log = 1;
                prt("Set to load log at end.\n");
            } else {
				pgm_exit(1,"ERROR: Unknown option [$arg] ... try -? ... aborting!\n" );
			}
		} else {
			# bare item - assume an INPUT file
			#$in_file = $arg;
			$in_file = File::Spec->rel2abs($arg);   # get ABSOLUTE path of input
            if (-f $in_file) {
               prt( "Set in file to [$in_file] ...\n" );
               push(@inp,$in_file);
            } else {
                prt( "Current Work Directory = [$pwd]\n" );
                pgm_exit(1,"ERROR: Can NOT locate IN FILE [$in_file]! check name, location! aborting...\n" );
            }
		}
		shift @av;
	}

    if ($had_frp && !$g_had_dsp) {
        pgm_exit(1,"ERROR: Option conflict! Had -fix_rel, but no -dsp=<dir> for output.\n");
    }

    $dn = scalar @inp;
    if ($dn) {
        prt( "Got $dn file(s) to process...\n" );
    } elsif ($debug_on) {
        if (-f $in_file) {
			$in_file = File::Spec->rel2abs($in_file);   # get ABSOLUTE path of input
            prt( "Using default file [$in_file]...\n" );
            push(@inp,$in_file);
        } else {
            prt( "ERROR: Can NOT locate DEFAULT file [$in_file]!\n" );
            $in_file = path_u2d($in_file);
            @inp = split(/\\/,$in_file);
            $dn = scalar @inp;
            $in_file = '';
            for ($i = 0; $i < $dn; $i++) {
                $arg = $in_file;
                $in_file .= "\\" if (length($in_file));
                $in_file .= $inp[$i];
                if (($i + 1) == $dn) {
                    if (! -f $in_file) {
                        prt("No file [$in_file], but found [$arg]\n" );
                        last;
                    }
                } elsif ( ! -d $in_file) {
                    prt("No directory [$in_file], but found [$arg]\n" );
                    if (opendir(DIR, $arg)) {
                        @inp = readdir(DIR);
                        closedir DIR;
                        $dn = scalar @inp;
                        $in_file = $arg;
                        my $fnd = '';
                        $dn = 0;
                        foreach $arg (@inp) {
                            next if (($arg eq '.')||($arg eq '.'));
                            $tmp = $in_file;
                            $tmp .= "\\" if ( !(($tmp =~ /\\$/)||($arg =~ /^\\/)) );
                            $tmp .= $arg;
                            if (-d $tmp) {
                                $dn++;
                                if ($dn == 5) {
                                    $fnd .= "\n  ";
                                    $dn = 0;
                                }
                                $fnd .= ' ' if (length($fnd));
                                $fnd .= $arg;
                            }
                        }
                        prt("But found $fnd\n" ) if (length($fnd));
                    }
                    last;
                }
            }
            pgm_exit(1,"ERROR ABORT: No file, or files to process...\n" );
        }
    } else {
        # no file(s), and not $debug_on
		give_help();
        pgm_exit(1,"ERROR: No input file found!\n");
    }
    if (! -d $out_dsp_dir) {
        pgm_exit(1,"ERROR: DSP out directory [$out_dsp_dir] does NOT exist! Aborting...");
    }
    return \@inp;
}

# eof - vcproj05.pl
