#!/usr/bin/perl -w
# NAME: fixdspfiles.pl
# AIM: VERY SPECIFIC - Modify a set of DSP files
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $perl_dir = 'C:\GTools\perl';
unshift(@INC, $perl_dir);
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 0;
my $in_file = '';
my $add_scc_entry = 0;

my $debug_on = 0;
my $def_file = 'C:\GTools\perl\temp';

### program variables
my @warnings = ();
my $cwd = cwd();
my $os = $^O;

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" );
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$i,$lnn,$chg,$proj_name,$nline);
    $lnn = 0;
	$chg = 0;
    $proj_name = "";
	for ($i = 0; $i < $lncnt; $i++) {
		$line = $lines[$i];
        chomp $line;
        $lnn++;
        if ($line =~ /\s{1}WIN32\s{1}/) {
            #prt("$lnn: $line\n");
			$line =~ s/\s{1}WIN32\s{1}/ Win32 /g;
			$chg++;
        }
        if ($line =~ /^CFG=(\w+)\s+/) {
            $proj_name = $1;
        }
        if ($line =~ /^\# PROP Scc_ProjName ""/) {
            $nline = "# PROP Scc_ProjName \"$proj_name\"";
            if ($add_scc_entry) {
                if (length($proj_name)) {
                    $line = $nline;
                    $chg++;
                }
            }
        }
		$lines[$i] = $line;
    }
	if ($chg) {
        prt("$proj_name: Made $chg lines changes in [$inf]...\n");
		rename2oldbak($inf);
		write2file(join("\n",@lines)."\n",$inf);
	}
}

sub process_in_dir($) {
    my ($dir) = @_;
    if (! opendir(DIR, $dir) ) {
        pgm_exit(1,"ERROR: Unable to open directory [$dir]\n"); 
    }
    my @files = readdir(DIR);
    closedir(DIR);
    my $fcnt = scalar @files;
    prt("Processing $fcnt files, from [$dir]...\n");
    my ($file,$inc,$lnn,$ff);
    $lnn = 0;
	$dir .= "\\" if (!($dir =~ /(\\|\/)$/));
    foreach $file (@files) {
		next if (($file eq '.')||($file eq '..'));
		$ff = $dir.$file;
		if (-f $ff) {
			if ($file =~ /\.dsp$/) {
				process_in_file($ff);
			}
		} elsif (-d $ff) {

		} else {
			prtw("WARNING: WHAT IS THIS? [$ff] [$file]\n");
		}
    }
}

#########################################
### MAIN ###
parse_args(@ARGV);
process_in_dir($in_file);
pgm_exit(0,"Normal exit(0)");
########################################
sub give_help {
    prt("$pgmname: version 0.0.1 2010-09-11\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help (-h or -?) = This help, and exit 0.\n");
}
sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n");
        }
        shift @av;
    }

    if ((length($in_file) ==  0) && $debug_on) {
        $in_file = $def_file;
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input directory found in command!\n");
    }
    if (! -d $in_file) {
        pgm_exit(1,"ERROR: Unable to find in folder [$in_file]! Check name, location...\n");
    }
}

# eof - fixdspfiles.pl
