#!/usr/bin/perl -w
# NAME: showincs.pl
# AIM: Read a C/C++ file and show included files...
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use File::Spec; # File::Spec->rel2abs($rel); # we are IN the SLN directory, get ABSOLUTE from RELATIVE
use Cwd;
my $perl_dir = 'C:\GTools\perl';
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl'! Check \@INC, or locations...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 0;
my $g_in_file = '';
my $g_in_root = '';

my $debug_on = 0;
my $def_file = 'C:\Projects\libsigc\libsigc++-2.2.8\sigc++\signal.cc';
my $def_root = 'C:\Projects\libsigc\libsigc++-2.2.8';

### program variables
my @warnings = ();
my $cwd = cwd();
my $os = $^O;
my %g_files_done = ();

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } elsif ($val) {
        prt( "\nNo warnings issued.\n\n" );
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    show_warnings($val);
    if (length($msg)) {
        $msg =~ s/\n$//;
    }
    prt("$msg ".localtime(time())."\n");
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($$);

sub fix_dir_string($) {
    my ($rdir) = @_;
    if (! ( ${$rdir} =~ /(\\|\/)$/) ) {
        ${$rdir} .= "\\";
    }
}

sub begins_with {
    my ($rt, $pt) = @_;
    my $ln = length($rt);
    my ($i);
    if (length($pt) >= $ln) {
        for ($i = 0; $i < $ln; $i++) {
            return 0 if (substr($rt,$i,1) ne substr($pt,$i,1));
        }
        return 1; # does indeed begin with...
    }
    return 0;
}

sub sub_first_from_second_if($$) {
    my ($d1,$d2) = @_;
    if (being_with($d1,$d2)) {
        $d2 = substr($d2, length($d1));
    }
    return $d2;
}

# VARIOUS FIXES FOR THE FILE NAME
# 1. ensure ALL DOS format
# 2. remove any simple dot relative, like '.\' from beginning
# 3. if given a FULL PATH name, remove C:\FG\20\FlightGear
# 4. if a relative name, remove FligthGear
# 5. if any removal, ensure any beginning '\' is removed
sub sub_root_dir($) {
    my ($ff) = shift;   # = $a_dir.$src
    $ff = path_u2d($ff);
    my $rd = $g_in_root; # get_root_dir();
    if (begins_with($rd, $ff)) {
        $ff = substr($ff, length($rd));
    }
    return $ff;
}

########################################################
### DIRECTORY SCANNING ###
sub si_do_dir_scan($$$);

sub si_do_dir_scan($$$) {
    my ($rparams,$dir,$lv) = @_;
    my $rda = ${$rparams}{'CURR_DIR_SCAN'};
    $dir .= "\\" if !($dir =~ /(\\|\/)$/);
    $dir = path_u2d($dir);
    my ($file,$ff,$n,$d);
    my @dirs = ();
    prt("Moment, doing full directory scan of [$dir]...\n") if ($lv == 0);
    if (opendir(DIR,$dir)) {
        my @files = readdir(DIR);
        closedir(DIR);
        foreach $file (@files) {
            next if (($file eq '.')||($file eq '..'));
            $ff = $dir.$file;
            if (-d $ff) {
                push(@dirs,$ff);
                next;
            }
            #             0     1   2 3
            push(@{$rda},[$file,$ff,0,0]);
        }
    }
    if (@dirs) {
        foreach $file (@dirs) {
            si_do_dir_scan($rparams,$file,$lv+1);
        }
    }
    if ($lv == 0) {
        $file = scalar @{$rda};
        prt("Done scan... got $file files...\n");
        ${$rparams}{'CURR_DONE_SCAN'} = 1;
    }
}

sub si_is_file_in_scan($$$$) {
    my ($rparams,$test,$inc,$ra) = @_;
    if (! ${$rparams}{'CURR_DONE_SCAN'} ) {
        my $dir = ${$rparams}{'CURR_IN_ROOT'};
        if (-d $dir) {
            si_do_dir_scan($rparams,$dir,0);
        } else {
            prtw("WARNING: Directory SEARCH FAILED! [$dir] NOT found!\n");
            return 0;
        }
    }
    my $rda = ${$rparams}{'CURR_DIR_SCAN'};
    my $cnt = scalar @{$rda};
    my ($i,$file,$fcnt,$ff);
    $fcnt = 0;
    for ($i = 0; $i < $cnt; $i++) {
        $file = ${$rda}[$i][0];
        #if ($test eq $file) {
        if ($inc eq $file) {
            $ff = ${$rda}[$i][1];
            # could now check if $fd at least partially matches, but for now
            push(@{$ra},$ff);
            $fcnt++;
        }
    }
    #prt("Directory SEARCH for [$inc] [$test], found $fcnt. Only 1st used.\n") if ($fcnt); # if ($dbg_lac20);
    return $fcnt;
}

sub process_in_file($$) {
    my ($rparams,$lev) = @_;
    my $inf = ${$rparams}{'CURR_IN_FILE'};
    my $rfd = ${$rparams}{'REF_FILES_DONE'};  # \%files_done
    my $rdo = ${$rparams}{'RA_FILES_DONE'};
    my $rid = ${$rparams}{'REF_INCS_DONE'};
    my $rincs = ${$rparams}{'REF_INCS_ARRAY'};
    my $cin_root = ${$rparams}{'CURR_IN_ROOT'};
    fix_dir_string(\$cin_root);

    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("\nProcessing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn,$name,$dir,$ff,$ch,$ok);
    my ($n,$d,$cnt,$i,$fcnt,@arr);
    ($name,$dir) = fileparse($inf);
    $dir = $cwd if ($dir =~ /^\.(\\|\/)$/);
    $lnn = 0;
    my @incs = ();
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        if ($line =~ /\s*#\s*include\s+(.+)$/) {
            $inc = $1;
    		$inc =~ s/\/\/.*$//;
    		$inc =~ s/\/\*.*$//;
            $inc = trim_all($inc);
            $ch = substr($inc,0,1);
            if ($inc =~ /<(.+)>/) {
                $inc =~ s/<(.+)>/$1/;
            } elsif ($inc =~ /"(.+)"/) {
                $inc =~ s/"(.+)"/$1/;
            }
            $ok = "NEW";
            ($n,$d) = fileparse($inc);
            if ( defined ${$rid}{$inc} ) {
                prt("Line $lnn: [$inc] via [$ch] DONE\n");
            } else {
                prt("Line $lnn: [$inc] via [$ch] $ok\n");
                $ff = $dir.$inc;
                $ok = 'NOT FOUND';
                if (-f $ff) {
                    $ok = 'ok';
                    prt("Line $lnn: [$inc] found 1 [$ff]\n");
                } else {
                    if ($inc =~ /(\\|\/)/) {
                        ($n,$d) = fileparse($inc);
                        $ff = $dir.$n;
                        if (-f $ff) {
                            $ok = 'ok';
                            prt("Line $lnn: [$inc] found 2 [$ff]\n");
                        } else {
                            $ff = $cin_root.$n;
                            if (-f $ff) {
                                $ok = 'ok';
                                prt("Line $lnn: [$inc] found 3 [$ff]\n");
                            } else {
                                @arr = ();
                                prt("Line $lnn: Checking [$inc] [$ff] in directory scan...\n");
                                if ( si_is_file_in_scan($rparams,$ff,$inc,\@arr) ) {
                                    $fcnt = scalar @arr;
                                    $ff = $arr[0];
                                    prt("Line $lnn: Returned $fcnt, trying [$ff] ");
                                    if (-f $ff) {
                                        $ok = 'ok';
                                    }
                                    prt(" $ok\n");
                                } elsif ($inc =~ /(\\|\/)/) {
                                    ($n,$d) = fileparse($inc);
                                    if ( si_is_file_in_scan($rparams,$ff,$n,\@arr) ) {
                                        $fcnt = scalar @arr;
                                        $ff = $arr[0];
                                        prt("Line $lnn: Returned $fcnt, trying [$ff] ");
                                        if (-f $ff) {
                                            $ok = 'ok';
                                        }
                                        prt(" $ok\n");
                                    }
                                } else {
                                    prt("Line $lnn: [$inc] NOT FOUND [$ff]\n");
                                }
                            }
                        }
                    } else {
                        $ff = $cin_root.$n;
                        if (-f $ff) {
                            $ok = 'ok';
                            prt("Line $lnn: [$inc] found 3 [$ff]\n");
                        } else {
                            @arr = ();
                            prt("Line $lnn: Checking [$inc] [$ff] in directory scan...\n");
                            if ( si_is_file_in_scan($rparams,$ff,$inc,\@arr) ) {
                                $fcnt = scalar @arr;
                                $ff = $arr[0];
                                prt("Line $lnn: Returned $fcnt, trying [$ff] ");
                                if (-f $ff) {
                                    $ok = 'ok';
                                }
                                prt(" $ok\n");
                            } else {
                                prt("Line $lnn: [$inc] NOT FOUND [$ff]\n");
                            }
                        }
                    }
                }
                ${$rid}{$inc} = $inf;
                ${$rfd}{$ff} = $inf;
                push(@{$rdo},$inf);
                #               0   1    2   3    4    5
                push(@{$rincs},[$ff,$inc,$ch,$lnn,$inf,$ok]);
                push(@incs,[$ff,$inc,$ch,$lnn,$inf,$ok]);
                prt("$lev: Stored:$ok: [$ff] [$inc] [$ch] [$lnn] [$inf]\n");
            }
        }
    }

    $cnt = scalar @incs;
    for ($i = 0; $i < $cnt; $i++) {
        $ff = $incs[$i][0];
        if (-f $ff) {
            ${$rparams}{'CURR_IN_FILE'} = $ff;
            process_in_file($rparams,($lev+1));
        } else {
            $inc = $incs[$i][1];
            $ch  = $incs[$i][2];
            prt("Unable to locate [$inc]! [$ch]... Searching dir scan...\n");
            @arr = ();
            if ( si_is_file_in_scan($rparams,$ff,$inc,\@arr) ) {
                $fcnt = scalar @arr;
                prt("Returned $fcnt, trying each...\n");
                foreach $ff (@arr) {
                    ${$rparams}{'CURR_IN_FILE'} = $ff;
                    process_in_file($rparams,($lev+1));
                }
            } elsif ($inc =~ /(\\|\/)/) {
                ($n,$d) = fileparse($inc);
                if ( si_is_file_in_scan($rparams,$ff,$n,\@arr) ) {
                    $fcnt = scalar @arr;
                    prt("Returned $fcnt, trying each...\n");
                    foreach $ff (@arr) {
                        ${$rparams}{'CURR_IN_FILE'} = $ff;
                        process_in_file($rparams,($lev+1));
                    }
                }
            }
        }
    }
}

sub show_found_list($) {
    my ($rparams) = @_;
    my $rh = ${$rparams}{'REF_FILES_DONE'};  # \%files_done
    my $inf = ${$rparams}{'MAIN_IN_FILE'};
    my $rdo = ${$rparams}{'RA_FILES_DONE'};
    my $rincs = ${$rparams}{'REF_INCS_ARRAY'};
    my ($key,$val,$k2,$v2,$file,$cnt,$done,$icnt,$key2);
    my ($ricnt,$ifile,$i,$ok,$min,$len,$vcnt);
    my %h = ();
    my $rh2 = \%h;
    $cnt = scalar @{$rdo};
    $ricnt = scalar @{$rincs};
    my %fdone = ();

    prt("\nIn the processing of [$inf]... found $cnt includes...\n");
    foreach $key (keys %{$rh}) {
        $val = ${$rh}{$key};    # get the file in which it was found
        ${$rh2}{$val} = [] if (!defined ${$rh2}{$val});
        $v2 = ${$rh2}{$val};
        push(@{$v2},$key);  # store what was found in that file
    }

    # now per the files searched
    $icnt = 0;
    %fdone = ();
    $min = 0;
    foreach $key2 (@{$rdo}) {
        if ( ! defined $fdone{$key2} ) {
            $fdone{$key2} = 1;
            $done = 0;
            foreach $key (keys %{$rh2}) {
                if ($key eq $key2) {
                    $val = ${$rh2}{$key};
                    $file = sub_root_dir($key);
                    # prt("File [$file] has...\n");
                    foreach $k2 (@{$val}) {
                        $icnt++;
                        $ok = 'Missed';
                        $file = sub_root_dir($k2);
                        #prt("Checking [$k2] in all incs..\n");
                        for ($i = 0; $i < $ricnt; $i++) {
                            #            0   1    2   3    4    5
                            #push(@incs,[$ff,$inc,$ch,$lnn,$inf,$ok]);
                            $ifile = ${$rincs}[$i][0];   # FULL FILE
                            #prt(" With [$ifile]...\n");
                            if ($ifile eq $k2) {
                                $ok = ${$rincs}[$i][5];
                                $file = ${$rincs}[$i][1];
                                last;
                            }
                        }
                        #prt(" $icnt: $file $ok\n");
                        $len = length($file);
                        $min = $len if ($len > $min);
                    }
                    $done = 1;
                }
            }
            if (!$done) {
                prt("Missed [$key2]! WHY?\n");
            }
        }
    }

    $icnt = 0;
    %fdone = ();
    foreach $key2 (@{$rdo}) {
        if ( ! defined $fdone{$key2} ) {
            $fdone{$key2} = 1;
            $done = 0;
            foreach $key (keys %{$rh2}) {
                if ($key eq $key2) {
                    $val = ${$rh2}{$key};
                    $file = sub_root_dir($key);
                    $vcnt = scalar @{$val};
                    prt("File [$file] has $vcnt 'include'...\n");
                    foreach $k2 (@{$val}) {
                        $icnt++;
                        $ok = 'Missed';
                        $file = sub_root_dir($k2); # dummy include
                        #prt("Checking [$k2] in all incs..\n");
                        for ($i = 0; $i < $ricnt; $i++) {
                            #            0   1    2   3    4    5
                            #push(@incs,[$ff,$inc,$ch,$lnn,$inf,$ok]);
                            $ifile = ${$rincs}[$i][0];   # FULL FILE
                            #prt(" With [$ifile]...\n");
                            if ($ifile eq $k2) {
                                $ok = ${$rincs}[$i][5];
                                $file = ${$rincs}[$i][1];   # get original INCLUDE
                                last;
                            }
                        }
                        $file .= ' ' while (length($file) < $min);
                        $ok .= " [$k2]" if ($ok eq 'ok');
                        prt(" $icnt: $file $ok\n");
                    }
                    $done = 1;
                }
            }
            if (!$done) {
                prt("Missed [$key2]! WHY?\n");
            }
        }
    }
}

sub setup_params($$) {
    my ($inf,$inr) = @_;
    my %params = ();
    my $rparams = \%params;
    ${$rparams}{'MAIN_IN_FILE'} = $inf;
    ${$rparams}{'CURR_IN_FILE'} = $inf;
    ${$rparams}{'CURR_IN_ROOT'} = $inr;
    my $rfd = \%g_files_done;
    ${$rparams}{'REF_FILES_DONE'} = $rfd;
    my @done_order = ();
    my $rdo = \@done_order;
    ${$rparams}{'RA_FILES_DONE'} = $rdo;
    my @incs = ();
    ${$rparams}{'REF_INCS_ARRAY'} = \@incs;
    my %incs_done = ();
    my $rid = \%incs_done;
    ${$rparams}{'REF_INCS_DONE'} = $rid;

    ${$rparams}{'CURR_DONE_SCAN'} = 0;
    ${$rparams}{'CURR_DIR_SCAN'} = [];

    return $rparams;
}

#########################################
### MAIN ###
parse_args(@ARGV);
prt( "$pgmname: in [$cwd]: Hello, World...\n" );
my $rph = setup_params($g_in_file,$g_in_root);
process_in_file($rph,0);
show_found_list($rph);
pgm_exit(0,"Normal exit(0)");
########################################
sub give_help {
    prt("$pgmname: version 0.0.1 2010-09-11\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help (-h or -?) = This help, and exit 0.\n");
    prt(" --root <dir> (-r) = Set ROOT directory.\n");
    prt("Purpose:\n");
    prt(" Treat the input files as a C/C++ file, and search for 'include' items.\n");
    prt("  Then each 'included' file will be searched, and a summary shown at the end.\n");
    prt("Notes:\n");
    prt(" If no root directory is given, the the directory of the in-file will be used as\n");
    prt("  the root. Obviously both the in-file and root directory MUST exist.\n");
}
sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^r/i) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $g_in_root = File::Spec->rel2abs($sarg);
                prt("Set root to [$g_in_root]\n");

            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $g_in_file = File::Spec->rel2abs($arg);
            prt("Set input to [$g_in_file]\n");
        }
        shift @av;
    }

    if ((length($g_in_file) ==  0) && $debug_on) {
        $g_in_file = File::Spec->rel2abs($def_file);
         prt("[debug_on] Set input to DEFAULT [$g_in_file]\n");
    }
    if ((length($g_in_root) ==  0) && $debug_on) {
        $g_in_root = File::Spec->rel2abs($def_root);
         prt("[debug_on] Set root to DEFAULT [$g_in_root]\n");
    }
    if (length($g_in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $g_in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$g_in_file]! Check name, location...\n");
    }
    if (length($g_in_root) == 0) {
        ($arg,$g_in_root) = fileparse($g_in_file);
    }
    fix_dir_string(\$g_in_root);
}

# eof - showincs.pl
