#!/usr/bin/perl -w
# lib_amscan.pl
# Library of services for scanning Makefile.am files
# 01/09/2010 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename; # to split path into ($name, $dir) = fileparse($ff); or ($nm,$dir,$ext) = fileparse( $fil, qr/\.[^.]*/ );
use Cwd;
my $cwd = cwd();

my $find_bad_source = 1;
my $show_dup_title = 0;
my $max_of_type = 30;

our ($dbg_s01, $dbg_s02, $dbg_s03, $dbg_s04, $dbg_s05, $dbg_s06, $dbg_s07, $dbg_s08,
     $dbg_s09, $dbg_s10, $dbg_s11, $dbg_s12, $dbg_s13, $dbg_s14, $dbg_s15, $dbg_s16,
     $dbg_s17, $dbg_s18, $dbg_s19, $dbg_s20
     );

# CONSTANTS
my $IF_PATTERN = "^if[ \t]+\([A-Za-z][A-Za-z0-9_]*\)[ \t]*\(#.*\)?\$";
my $IFD_PATTERN = "^ifdef[ \t]+\([A-Za-z][A-Za-z0-9_]*\)[ \t]*\(#.*\)?\$";
my $NIF_PATTERN = "^if[ \t]+!(.+)\$";
my $NIF_PATTERN2 = "^if!\\s+(.+)\$";
my $ELSE_PATTERN = "^else[ \t]*\(#.*\)?\$";
my $ENDIF_PATTERN = "^endif[ \t]*\(#.*\)?\$";
my $PATH_PATTERN = '(-|\\w|/|\\.)+';
my $INCLUDE_PATTERN = "^include[ \t]+((\\\$\\\(top_srcdir\\\)/${PATH_PATTERN})|(\\\$\\\(srcdir\\\)/${PATH_PATTERN})|([^/\\\$]${PATH_PATTERN}))[ \t]*(#.*)?\$";

#####################################################
#####################################################
# FOR DEBUG
my $am_dbg_base = 'dbg_s';
sub am_set_dbg_base($) { $am_dbg_base = shift; }
sub am_dbg_val_var($) {
    my $val = shift;
    my $var = $am_dbg_base;
    if ($val < 10) {
        $var .= "0$val";
    } else {
        $var .= "$val";
    }
    return $var;
}
sub am_get_dbg_var($) {
    my $val = shift;
    my $var = am_dbg_val_var($val);
    my $res = -1;
    # from : http://perldoc.perl.org/functions/eval.html
    if (eval "defined \$$var") {
        $res = eval "\$$var";
    }
    return $res;
}

sub am_get_dbg_stg() {
    my $s = '';
    my ($i,$res,$i2);
    for ($i = 1; ;$i++) {
        $res = am_get_dbg_var($i);
        last if ($res == -1);
        if ($i < 10) {
            $i2 = "0$i";
        } else {
            $i2 = "$i";
        }
        if ($res) {
            $s .= "$i2 ";
        }
    }
    return $s;
}

sub am_get_dbg_range() {
    my ($i,$res);
    for ($i = 1; ;$i++) {
        $res = am_get_dbg_var($i);
        last if ($res == -1);
    }
    return $i - 1;
}

sub am_set_dbg_var($) {
    my $val = shift;
    my $var = am_dbg_val_var($val);
    # from : http://perldoc.perl.org/functions/eval.html
    # NOT $$var++; # does not work!
    if (eval "defined \$$var") {
        eval "\$$var = 1";
    } else {
        #print "ERROR: \$$var does NOT exist\n";
        return 0;
    }
    return 1;
}

sub am_clear_dbg_var($) {
    my $val = shift;
    my $var = am_dbg_val_var($val);
    # from : http://perldoc.perl.org/functions/eval.html
    # NOT $$var++; # does not work!
    if (eval "defined \$$var") {
        eval "\$$var = 0";
    } else {
        #print "ERROR: \$$var does NOT exist\n";
        return 0;
    }
    return 1;
}

sub am_set_all_dbg_on() {
    my ($i,$res);
    for ($i = 1; ;$i++) {
        $res = am_set_dbg_var($i);
        last if (!$res);
    }
}

sub am_set_all_dbg_off() {
    my ($i,$res);
    for ($i = 1; ;$i++) {
        $res = am_clear_dbg_var($i);
        last if (!$res);
    }
}

######################################################
### DIRECTORY SCAN STUFF - moved to lib_acscan.pl
#####################################################
## SUBSTITUTIONS
## =============

sub am_macro_split($$) {
    my ($txt,$add) = @_;
    my @arr = ();
    my $len = length($txt);
    my ($i,$tag,$ch,,$nc,$mac,$k);
    $tag = '';
    for ($i = 0; $i < $len; $i++) {
        $ch = substr($txt,$i,1);
        if ($ch eq '$') {
            $k = $i + 1;
            if ((($k+3) < $len)&&(substr($txt,$k,1) eq '(')) {
                $k++;
                $mac = '$(';
                for (; $k < $len; $k++) {
                    $nc = substr($txt,$k,1);
                    $mac .= $nc;
                    last if ($nc eq ')');
                    last if !($nc =~ /\w/);
                }
                if ($nc eq ')') {
                    push(@arr,$tag) if (length($tag) && $add);
                    $tag = '';
                    push(@arr,$mac);
                    $ch = '';
                    $i = $k;
                }
            }
        } elsif ($ch eq '@') {
            $k = $i + 1;
            if ((($k+1) < $len) && (substr($txt,$k) =~ /^(\w+)\@/)) {
                $mac = '@';
                for (; $k < $len; $k++) {
                    $nc = substr($txt,$k,1);
                    $mac .= $nc;
                    last if ($nc eq '@');
                    last if ($nc =~ /\W/);
                }
                if ($nc eq '@') {
                    push(@arr,$tag) if (length($tag) && $add);
                    $tag = '';
                    push(@arr,$mac);
                    $ch = '';
                    $i = $k;
                }
            }
        }
        if ($add && (($ch eq "'") || ($ch eq '"'))) {
            push(@arr,$tag) if (length($tag));
            $tag = '';
            push(@arr,$ch);
        } else {
            $tag .= $ch;
        }
    }
    return @arr;
}


#sub test_for_substitution($$$$) {
#    my ($line,$rhash,$i2,$sfil) = @_;
# 09/09/2010 - also try to EXPAND @ABC@ macros
sub am_test_for_substitution($) {
    my ($rparams) = @_;
    my $line = ${$rparams}{'CURR_LINE'};
    if (($line =~ /\$/)||($line =~ /\@\w+\@/)) {
        my $rhash = ${$rparams}{'CURR_REF_HASH'};
        my $i2 = ${$rparams}{'CURR_LINENUM'};
        my $fil = ${$rparams}{'AM_FILE'};
        my $rcomsubs = ${$rparams}{'REF_COMMON_SUBS'};
        my $rsnf = ${$rparams}{'CURR_SUBS_NOT_FOUND'};
        my $sfil = sub_root_folder($fil);
        my $oline = $line; # keep copy of original
        my @arr = am_macro_split($line,0);
        my ($itm,$key,$nval,$tmp,$done,$cnt,$typ);
        $cnt = 0;
        foreach $itm (@arr) {
            $typ = 0;
            if ($itm =~ /^\$\((\w+)\)$/) {
                $key = $1;
                $done = 0;
                $typ = 1;    # is of form $(MACRO)
                if (defined ${$rhash}{$key}) {
                    $nval = ${$rhash}{$key};
                    $line =~ s/\$\($key\)/$nval/;
                    prt("[13] $i2:1:$key: Did sub of [$key] to [$nval]\n") if ($dbg_s13);
                    $done = 1;
                    $cnt++;
                } else {
                    foreach $tmp (keys %{$rhash}) {
                        if ($tmp =~ /^$key\s+.+\@_TRUE\@/) {
                            $nval = ${$rhash}{$tmp};
                            $line =~ s/\$\($key\)/$nval/;
                            prt("[13] $i2:2: Did sub to [$nval] key [$key] tmp = [$tmp]\n") if ($dbg_s13);
                            $done = 1;
                            $cnt++;
                            last;
                        }
                    }
                }
                if (!$done) {
                    # try in the common, which can be user expanded
                    if (defined ${$rcomsubs}{$key}) {
                        $nval = ${$rcomsubs}{$key};
                        $line =~ s/\$\($key\)/$nval/;
                        prt("[13] $i2:3: Did sub to [$nval] key [$key] common subs\n") if ($dbg_s13);
                        $done = 1;
                        $cnt++;
                    }
                }

                if (!$done) {
                    prt("[13|14] $i2:$typ: NO sub FOUND for [$itm] key [$key]  file [$sfil]\n") if ($dbg_s13 || $dbg_s14);
                    #$subs_not_found{$key} = $sfil;
                    if (! defined ${$rsnf}{$key}) {
                        ${$rsnf}{$key} = "$i2:$sfil";
                    }
                }
            } elsif ($itm =~ /^\@(\w+)\@$/) {
                $key = $1;
                $done = 0;
                $typ = 2;   # is of the form @MACRO@
                if (defined ${$rhash}{$key}) {
                    $nval = ${$rhash}{$key};
                    $line =~ s/\@$key\@/$nval/;
                    prt("[13] $i2:1:$key: Did sub of [$key] to [$nval]\n") if ($dbg_s13);
                    $done = 1;
                    $cnt++;
                } else {
                    foreach $tmp (keys %{$rhash}) {
                        if ($tmp =~ /^$key\s+.+\@_TRUE\@/) {
                            $nval = ${$rhash}{$tmp};
                            $line =~ s/\@$key\@/$nval/;
                            prt("[13] $i2:2: Did sub to [$nval] key [$key] tmp = [$tmp]\n") if ($dbg_s13);
                            $done = 1;
                            $cnt++;
                            last;
                        }
                    }
                }
                if (!$done) {
                    # try in the common, which can be user expanded
                    if (defined ${$rcomsubs}{$key}) {
                        $nval = ${$rcomsubs}{$key};
                        $line =~ s/\@$key\@/$nval/;
                        prt("[13] $i2:3: Did sub to [$nval] key [$key] common subs\n") if ($dbg_s13);
                        $done = 1;
                        $cnt++;
                    }
                }

                if (!$done) {
                    #$subs_not_found{$key} = $sfil;
                    prt("[13|14] $i2:$typ: NO sub FOUND for [$itm] key [$key]  file [$sfil]\n") if ($dbg_s13 || $dbg_s14);
                    if (! defined ${$rsnf}{$key}) {
                        # keep only the FIRST instance
                        ${$rsnf}{$key} = "$i2:$sfil";
                    }
                }
            } else {
                prtw("WARNING: am_test_for_substitution: got a split NOT handled! [$itm]\n");
            }
        }
        if ($line ne $oline) {
            prt("[13] $i2: Line SUB [$oline] TO [$line]\n") if ($dbg_s13);
        } elsif ($cnt) {
            pgm_exit(1,"$i2:$cnt: SUBSTITUTIONS FAILED! line [$line] file [$sfil]\n");
        }
    }
    return $line;
}

########################################################
# given two scalar items, separated by '\s' or '\'
# reutrn ZERO if ALL the second are IN the first.
sub value_not_in_first($$) {
    my ($src,$rval) = @_;    # $programs{$ky},$val
    my @arr1 = split(/[\s\|]/,$src);
    my $val2 = ${$rval};
    my @arr2 = split(/[\s\|]/,$val2);
    my $cnt = scalar @arr2;
    my ($val1,$dcnt);
    if ($cnt == 1) {
        foreach $val1 (@arr1) {
            return 0 if ($val1 eq $val2);
        }
    } else {
        # put values in a hash, to allow delete
        my %vals = ();
        foreach $val1 (@arr2) {
            $vals{$val1} = 1;
        }
        $dcnt = 0;
        foreach $val1 (@arr1) {
            if (defined $vals{$val1}) {
                delete $vals{$val1};
                $dcnt++;
            }
        }
        if ($dcnt) {
            @arr1 = keys(%vals);
            return 0 if (scalar @arr1 == 0);
            # but if there were 'some' items delete due to existance
            # then adjust the original $val...
            ${$rval} = join(' ',@arr1);
        }
    }
    return 1;
}

sub get_value_from_hash {
    my ($rval2,$ms,$rhash,$rparams) = @_;
    my ($ky2, @vals, $fnd, $val, @keys, $i);
    my ($itm, $cond);
    my $rdef_conds = ${$rparams}{'REF_DEF_CONDITIONS'};

    $fnd = 0;

    foreach $ky2 (keys %{$rhash}) {
        if ($ky2 =~ /^$ms\s+/) {
            $val = ${$rhash}{$ky2};
            if (!is_in_array($val, @vals)) {
                push(@vals,$val);
                push(@keys,$ky2);
                $fnd++;
            }
        }
    }
    if ($fnd == 1) {
        $$rval2 = $vals[0]; # just ONE to RETURN
    } elsif ($fnd > 1) {
        my $msg = "WARNING: For sub of [$ms], have [$fnd] to CHOOSE FROM!\n";
        for ($i = 0; $i < $fnd; $i++) {
            $val = $vals[$i];
            $ky2 = $keys[$i];
            $msg .= " or \n" if ($i > 0);
            $msg .= "[$ky2={".$val.'}]';
            if ($ky2 =~ /^$ms\s+if\s+(\w+)\@_(TRUE|FALSE)\@/) {
                $itm = $1;
                $cond = $2;
                $msg .= " [$itm]=[$cond]";
                if (defined ${$rdef_conds}{$itm}) {
                    if (${$rdef_conds}{$itm} eq $cond) {
                        $$rval2 = $val; # RETURN selected
                        ### prtw("CHECK: Returning [$val] for [$ms], due [$itm]=[$cond] in def_condits!\n" );
                        return $fnd;
                    }
                }
            }
        }
        $msg .= " Defaulting to FIRST! CHECK ME!!";
        prtw("$msg\n");
        ${$rval2} = $vals[0]; # just RETURN first
    }
    return $fnd;
}

# extract info from one am file scan,
# and try to do any substitutions, twice, but these should have been done already,
# done at end of each process_AM_file, with the reference hash collected
#sub extract_from_hash($$$$) {
#    my ($fil, $rhash, $rprogs, $rlibs) = @_;
sub am_extract_from_hash($) {
    my ($rparams) = @_;
    my $fil = ${$rparams}{'AM_FILE'};

    # store for programs and library SOURCES
    # under the key of the program or library name
    my $rprogs = ${$rparams}{'REF_PROGRAMS'};
    my $rlibs = ${$rparams}{'REF_LIBRARIES'};
    # the actual (messy) Makefile.am HASH
    my $rhash = ${$rparams}{'CURR_REF_HASH'};
    # common substitutions
    my $rcomsubs = ${$rparams}{'REF_COMMON_SUBS'};
    my $rglobhash = ${$rparams}{'REF_GLOBAL_HASH'};
    my $rdnf = ${$rparams}{'REF_DEFS_NOT_FOUND'};
    my $rsnf = ${$rparams}{'CURR_SUBS_NOT_FOUND'};
    my $rexcept = ${$rparams}{'REF_SRC_EXCEPT'};

    # reference to the script exit value, should thre be a problem
    my $rexit_val = ${$rparams}{'REF_EXIT_VALUE'};

    my ($a_nm, $a_dir) = fileparse($fil);
    my ($key, $val, @av);
    my (@skeys, @progs, @progkeys, @libs, @libkeys, @srcs, @srckeys);
    my ($ky, $vky, $ms, $val2, $ky2, $orgval, $fnd, $acnt);
    my ($src, $ff, $scnt, $i, $min, $len, $oky, $fcnt);
    my ($tot_scnt);
    #my %extract = ();
    # really interested in 
    # noinst_LIBRARIES = libAirports.a
    # noinst_PROGRAMS = calc_loc
    # bin_PROGRAMS = fgfs something
    # libAirports_a_SOURCES = apt_loader.cxx apt_loader.hxx ...
    @skeys = sort keys(%{$rhash});
    $acnt = scalar @skeys;
    prt( "[02] extract_from_hash: Listing $acnt keys in hash passed... file [$fil]\n" ) if ($dbg_s02);
    # collect PROGRAM keys
    @progs = ();
    @progkeys = ();
    @libs = ();
    @libkeys = ();
    @srcs = ();
    @srckeys = ();

    # try to do substitutions
    $min = 0;
    foreach $key (@skeys) {
        $val = ${$rhash}{$key};
        $orgval = $val;
        next if (!defined $val || (length($val) == 0));
        if ($val =~ /\$\((\w+)\)/) {
            $ms = $1;
            $val2 = ''; # no sub yet
            $fnd = 0;   # none found
            if (defined ${$rhash}{$ms}) {
                $val2 = ${$rhash}{$ms}; # found in local
                $fnd = 3;
            } elsif (defined ${$rcomsubs}{$ms}) {
                $val2 = ${$rcomsubs}{$ms}; # found in common
                $fnd = 2;
            } elsif (defined ${$rglobhash}{$ms}) {
                $val2 = ${$rglobhash}{$ms};  # found in global
                $fnd = 1;
            } else {
                # hmmm, maybe like 'GFX_CODE if @USE_GLUT_FALSE@ = fg_os_osgviewer.cxx $(GFX_COMMON)'
                $fnd = get_value_from_hash(\$val2, $ms, $rhash, $rparams ); 
            }
            if ($fnd > 0) {
                $val =~ s/\$\($ms\)/$val2/g;
            } else {
                # ONLY ON SECOND RUN
                #if ( ! (defined ${$rdnf}{$ms} || defined ${$rsnf}{$ms}) ) {
                #    prtw("[10] WARNING:1: No definition for [$ms] found in hash ...\n" ) if ($dbg_s10);
                #    ${$rdnf}{$ms} = $fil;
                #    ${$rsnf}{$ms} = $fil;
                #}
                #if ( ! is_in_array($ms,@subsnotfound) ) {
                #    prtw("[10] WARNING:1: No substitution for [$ms] found in hash ...\n" ) if ($dbg_s10);
                #    push(@subsnotfound,$ms);
                #}
            }
        }

        if ($val ne $orgval) {
            ${$rhash}{$key} = $val;
        }
        $len = length($key);
        $min = $len if ($len > $min);
    }

    # try to do substitutions, TWICE
    foreach $key (@skeys) {
        $val = ${$rhash}{$key};
        next if (!defined $val || (length($val) == 0));
        $orgval = $val;
        if ($val =~ /\$\((\w+)\)/) {
            $ms = $1;
            $val2 = '';
            $fnd = 0;
            if (defined ${$rhash}{$ms}) {
                $val2 = ${$rhash}{$ms};
                $fnd = 3;
            } elsif (defined ${$rcomsubs}{$ms}) {
                $val2 = ${$rcomsubs}{$ms}; # found in common
                $fnd = 2;
            } elsif (defined ${$rglobhash}{$ms}) {
                $val2 = ${$rglobhash}{$ms};
                $fnd = 1;
            } else {
                # hmmm, maybe like 'GFX_CODE if @USE_GLUT_FALSE@ = fg_os_osgviewer.cxx $(GFX_COMMON)'
                foreach $ky2 (keys %{$rhash}) {
                    if ($ky2 =~ /^$ms/) {
                        $val2 = ${$rhash}{$ky2};
                        $fnd = 4;
                        last;
                    }
                }
            }
            if ($fnd > 0) {
                $val =~ s/\$\($ms\)/$val2/g;
            } else {
                if ( ! (defined ${$rdnf}{$ms} || defined ${$rsnf}{$ms}) ) {
                    prtw("[10] WARNING:1: No definition for [$ms] found in hash ...\n" ) if ($dbg_s10);
                    ${$rdnf}{$ms} = $fil;
                    ${$rsnf}{$ms} = $fil;
                }
            }
        }
        if ($val ne $orgval) {
            ${$rhash}{$key} = $val;
        }
    }

    my %htmp = ();
    ### my $max_of_type = ${$rparams}{'MAX_OF_TYPE'};
    my $add_rel_sources = ${$rparams}{'ADD_REL_SOURCE'};
    my $root_folder = ${$rparams}{'ROOT_FOLDER'};
    my $try_harder = ${$rparams}{'TRY_HARDER'};
    my $try_much_harder = ${$rparams}{'TRY_MUCH_HARDER'};
    my $ignore_EXTRA_DIST = ${$rparams}{'IGNORE_EXTRA_DIST'};
    foreach $key (@skeys) {
        $val = ${$rhash}{$key};
        if (!defined $val) {
            delete ${$rhash}{$key};
            prtw("WARNING: Deleted key [$key] from hash ref! How did this get here?\n");
            next;
        }
        if ($key =~ /_PROGRAMS/) {
            push(@progkeys,$key);
            push(@progs,$val);
            $ms = "PROGRAMS";
        } elsif (($key =~ /_LIBRARIES/)||($key =~ /_LTLIBRARIES/)) {
            push(@libkeys,$key);
            push(@libs,$val);
            $ms = "LIBRARIES";
        } elsif (($key =~ /_SOURCES/)||($key =~ /_EXTRASOURCES/)||($key =~ /_AUXSOURCES/)) {
            push(@srckeys,$key);
            ###push(@srcs,$val);    # will scan and massage the sources later
            $ms = "SOURCES";
        } else {
            $ms = "*SKIPPED*";
            if (($key =~ /_/) &&
                (($key =~ /PROGRAMS/)||($key =~ /LIBRARIES/)||($key =~ /SOURCES/))) {
                if (! defined ${$rexcept}{$key}) {
                    # found bin_JAVAPROGRAMS CSHARPPROGRAMS hello_RESOURCES
                    prtw("WARNING: *** CHECK ME *** Got [$key] val = [$val] *** CHECK ME ***\n".
                        " SHOULD THIS ITEMS BE INCLUDED IN THE ACCUMULATION [$fil]\n");
                    ${$rexcept}{$key} = 1; # only output ONCE
                    if ( !(($key =~ /JAVA/)||($key =~ /CSHARP/)||($key =~ /RESOURCES/)||($key =~ /PASCAL/)) ) {
                        ${$rexit_val} = 1;
                    }
                }
            }
        }
        $htmp{$ms} = [] if ( ! defined $htmp{$ms});
        # list the sources, but this is JUST for DISPLAY
        #@av = split(/\s/,$val);    # SPLIT LIST
        @av = split(/[\s\|]/,$val); # SPLIT LIST
        $val = '';
        foreach $oky (@av) {
            $oky = path_u2d($oky);
            $oky =~ s/\\\\/\\/ while ($oky =~ /\\\\/); # eliminate duplicate back slashes
            if (($oky =~ /^\w{1}:/)||($oky =~ /^-/)) {
                $src = sub_root_dir($oky); # already has a DRIVE beginning, so use AS IS
            } else {
                $src = sub_root_dir($a_dir.$oky);
                $src = path_u2d($src);
                $src =~ s/\\\\/\\/ while ($src =~ /\\\\/); # eliminate duplicate back slashes
            }
            $val .= ' ' if (length($val));
            $val .= $src;
        }
        push(@{$htmp{$ms}}, [$key,$val]);
    }

    if ($dbg_s16) {
        $min = 0;
        prt("\n[16] Enumeration of the temporary HASH - only for DEBUG\n");
        foreach $ms (keys %htmp) {
            $ky = $htmp{$ms};
            $scnt = scalar @{$ky};
            prt("[16] $scnt of type [$ms] file [$fil]\n");
            for ($i = 0; $i < $scnt; $i++) {
                $src = ${$ky}[$i][0];
                $len = length($src);
                $min = $len if ($len > $min);
            }
            $min = $max_of_type if ($min > $max_of_type);
            for ($i = 0; $i < $scnt; $i++) {
                $src = ${$ky}[$i][0];
                $val = ${$ky}[$i][1];
                $src .= ' ' while (length($src) < $min);
                prt(" $src = [$val]\n");
            }
        }
        prt("[16] End enumeration of temporary hash...\n");
    }

    # =======================================================================
    if ($dbg_s02) {
        $val = scalar @skeys;
        prt("\n[02] List of $val items in the HASH from [$fil]...\n");
        foreach $key (@skeys) {
            $val = $$rhash{$key};
            next if (($key eq 'EXTRA_DIST')&&($ignore_EXTRA_DIST));
            $key .= ' ' while (length($key) < $min);
            prt(" $key = $val\n" );
        }
        prt("[02] Done List of $val items in the HASH from [$fil]...\n");
    }

    # ### PROCESS LIBRARY SOURCES - stored in $rlibs
    # ===========================
    if (@libkeys) {
        $val = scalar @libkeys;
        prt( "[03] Find sources for $val LIBRARY keys ...\n" ) if ($dbg_s03);
        $tot_scnt = 0;
        foreach $key (@libkeys) {
            $val = ${$rhash}{$key};
            #@av = split(/\s/,$val);
            @av = split(/[\s\|]/,$val); # SPLIT LIST
            prt( "[03] Find sources for LIBRARY [$key] [$val]\n" ) if ($dbg_s03);
            foreach $oky (@av) {
                $ky = $oky;
                $ky =~ s/-/_/g;
                $ky =~ s/\./_/g;
                $ky =~ s/\|//g;
                $ky = trim_all($ky);
                prt( "[03] Finding [$oky] [$ky]\n" ) if ($dbg_s03);
                next if (length($ky) == 0);
                #next if (($ky =~ /\@/)||($ky =~ /\$/));
                $vky = $ky.'_SOURCES';
                $fnd = 0;
                if (defined ${$rhash}{$vky}) {
                    $val = ${$rhash}{$vky};
                    $fnd = 1;
                } else {
                    foreach $val (keys %{$rhash}) {
                        if (($val =~ /$oky/) && ($val =~ /SOURCE/i)) {
                            $vky = $val;
                            $val = ${$rhash}{$vky};
                            $fnd = 1;
                            last;
                        }
                    }
                }
                if ($fnd) {
                    #@srcs = split(/\s/, $val);
                    @srcs = split(/[\s\|]/,$val); # SPLIT LIST
                    $scnt = scalar @srcs;
                    $tot_scnt += $scnt;
                    for ($i = 0; $i < $scnt; $i++) {
                        $val = $srcs[$i];
                        $src = path_u2d($val);
                        if ($add_rel_sources) {
                            $ff = sub_root_dir($a_dir.$src);
                            if ($src ne $ff) {
                                prt("[18] LIB: Changed src from [$src], to [$ff]. [$a_dir]\n") if ($dbg_s18);
                                $srcs[$i] = $ff;
                            } elsif ($src ne $val) {
                                prt("[18] LIB: Changed src from [$val] to [$src]\n") if ($dbg_s18);
                                $srcs[$i] = $src;
                            }
                        } elsif ($src ne $val) {
                            prt("[18] LIB: Changed src from [$val] to [$src]\n") if ($dbg_s18);
                            $srcs[$i] = $src;
                        }
                    }
                    $val = join(' ',@srcs);
                    if (defined ${$rlibs}{$ky}) {
                        $ms = ${$rlibs}{$ky};
                        if ( value_not_in_first($ms,\$val) ) {
                            prtw( "WARNING: libraries [$ky] has value [$ms] ADDING [$val]!\n" );
                            ${$rlibs}{$ky} .= ' '.$val;
                        }
                    } else {
                        ${$rlibs}{$ky} = $val;
                    }
                    my $rlh = ${$rparams}{'REF_LIBS_HASH'};
                    ${$rlh}{$ky} = $rhash; # keep the original Makefile.am hash scan
                    prt( "[04] LIBRARY [$ky] has SOURCES [$val]\n" ) if ($dbg_s04);
                } else {
                    $ms = '';
                    $scnt = 0;
                    foreach $val (keys %{$rhash}) {
                        if ($val =~ /SOURCE/i) {
                            $ms .= ' ' if (length($ms));
                            $ms .= $val;
                            $scnt++;
                        }
                    }
                    prt("But found $scnt keys [$ms] in HASH! Is it ONE of these?\n") if (length($ms));
                    prtw( "WARNING: No sources for LIBRARY [$ky] key [$vky] o [$oky],\n in file [$fil]\n" );
                }
            }
        }
        $val = scalar @libkeys;
        prt( "[03] Done sources for $val LIBRARY keys ... found $tot_scnt...\n" ) if ($dbg_s03);
    } else {
        prt( "[03] No LIBRARY keys ...\n" ) if ($dbg_s03);
    }

    #### PROCESS PROGRAM SOURCES - stored in $rprogs
    #### =======================
    if (@progkeys) {
        foreach $key (@progkeys) {
            $val = $$rhash{$key};
            #@av = split(/\s/,$val);
            @av = split(/[\s\|]/,$val); # SPLIT LIST
            foreach $oky (@av) {
                $ky = $oky;
                $ky =~ s/-/_/g;
                $ky =~ s/\./_/g;
                $ky = trim_all($ky);
                next if (length($ky) == 0);
                next if (($ky =~ /\@/)||($ky =~ /\$/));
                $vky = $ky.'_SOURCES';
                $fnd = 0;
                if (defined $$rhash{$vky}) {
                    $val = $$rhash{$vky};
                    $fnd = 1;
                } else {
                    foreach $val (keys %{$rhash}) {
                        if (($val =~ /$oky/) && ($val =~ /SOURCE/i)) {
                            $vky = $val;
                            $val = $$rhash{$vky};
                            $fnd = 1;
                            last;
                        }
                    }
                }
                if (!$fnd && $try_harder) {
                    # search the HASH harder
                    foreach $ky2 (keys %{$rhash}) {
                        $val2 = $$rhash{$ky2};
                        @srcs = split(/[\s\|]/,$val2); # SPLIT LIST
                        foreach $src (@srcs) {
                            if (($src =~ /$oky\./) && is_c_source_extended($src) ) {
                                $val = $src;
                                $fnd = 1;
                                last;
                            }
                        }
                    }
                }
                if (!$fnd && $try_much_harder && ($oky =~ /^[-\w\.]+$/)) {
                    # do_dir_scan($root_folder,0) if (!$done_dir_scan);
                    @srcs = ();
                    $fcnt = ac_match_dir_for_c_source($rparams,$oky,$a_dir,\@srcs);
                    if ($fcnt) {
                       $val = $srcs[0];
                       $fnd = 1;
                    }
                }
                if ($fnd && length($val)) {
                    #@srcs = split(/\s/, $val);
                    @srcs = split(/[\s\|]/,$val); # SPLIT LIST
                    $scnt = scalar @srcs;
                    for ($i = 0; $i < $scnt; $i++) {
                        $val = $srcs[$i];
                        $src = path_u2d($val);
                        if ($add_rel_sources) {
                            $ff = sub_root_dir($a_dir.$src);
                            if ($src ne $ff) {
                                prt("[18] PRG: Changed src from [$src], to [$ff]. [$a_dir]\n") if ($dbg_s18);
                                $srcs[$i] = $ff;
                            } elsif ($src ne $val) {
                                prt("[18] PRG: Changed src from [$val], to [$src].\n") if ($dbg_s18);
                                $srcs[$i] = $src;
                            }
                        } elsif ($src ne $val) {
                            prt("[18] PRG: Changed src from [$val], to [$src].\n") if ($dbg_s18);
                            $srcs[$i] = $src;
                        }
                    }
                    $val = join(' ',@srcs);
                    if (defined ${$rprogs}{$ky}) {
                        $ms = ${$rprogs}{$ky};
                        if ( value_not_in_first($ms,\$val) ) {
                            prtw( "WARNING: programs [$ky] has value [$ms] ADDING [$val]!\n" );
                            ${$rprogs}{$ky} .= ' '.$val;
                        }
                    } else {
                        ${$rprogs}{$ky} = $val;
                    }
                    my $rph = ${$rparams}{'REF_PROG_HASH'};
                    ${$rph}{$ky} = $rhash; # keep the original Makefile.am hash scan
                    prt( "[04] PROGRAM [$ky] has SOURCES [$val]\n" ) if ($dbg_s04);
                } else {
                    $ms = '';
                    $scnt = 0;
                    foreach $val (keys %{$rhash}) {
                        if ($val =~ /SOURCE/i) {
                            $ms .= ' ' if (length($ms));
                            $ms .= $val;
                            $scnt++;
                        }
                    }
                    prt("But found $scnt keys [$ms] in HASH! Is it ONE of these?\n") if (length($ms));
                    prtw("WARNING: No sources for PROGRAM [$ky] key [$vky] org [$oky],\n in file [$fil]\n" );
                }
            }
        }
    } else {
        prt( "[03] No PROGRAM keys ...\n" ) if ($dbg_s03);
    }
    prt( "[02] extract_from_hash: Done $acnt from [".sub_root_folder($fil)."]...\n" ) if ($dbg_s02);
    # return \%extract;
}


# lev = 1 = no plus sign, so should be first init of item
#           and warn if it is NOT
# lev = 2 = Had a plus sign, is += so variable SHOULD exist
#           and warn if it does NOT, if $warn_on_plus
#sub add_key_value_2_hash($$$$$$) {
#    my ($key,$val,$rhash,$i2,$sfil,$lev) = @_;
sub add_key_value_2_hash($$) {
    my ($rparams,$lev) = @_;
    my $rhash = ${$rparams}{'CURR_REF_HASH'};
    my $i2 = ${$rparams}{'CURR_LINENUM'};
    my $key = ${$rparams}{'CURR_KEY'};
    my $val = ${$rparams}{'CURR_VAL'};
    my $sfil = ${$rparams}{'AM_FILE'};
    my $warn_on_plus = ${$rparams}{'VALUE_WARN_ON_PLUS'};
    my ($tmp,$done,$cval);
    if (defined ${$rhash}{$key}) {
        $cval = ${$rhash}{$key};
        prtw( "WARNING: $i2: hash [$key] exists with [$cval]! Adding [$val]! $lev! file [$sfil]\n" ) if ($lev == 1);
        ${$rhash}{$key} .= '|'.$val;
        $tmp = 'Added to';
    } else {
        # hmmm, maybe have a key like 'jack_freebob_la_SOURCES if HAVE_ALSA_MIDI@_TRUE@'
        $done = 0;
        if ($key =~ /\s/) {
            my @arr = split(/\s/,$key);
            my $cnt = scalar @arr;
            $tmp = $arr[0];
            if (($cnt >= 3) && (defined ${$rhash}{$tmp})) {
                $cval = ${$rhash}{$key};
                $key = $tmp;
                prtw( "WARNING: $i2: hash [$key] exists with [$cval]! Adding [$val]! $lev! file [$sfil]\n" ) if ($lev == 1);
                ${$rhash}{$key} .= '|'.$val;
                $done = 1;
                $tmp = 'Added (assume TRUE)';
            }
        }
        if (!$done) {
            prtw( "WARNING: $i2: hash [$key] DOES NOT EXIST! $lev! file [$sfil]\n" ) if (($lev == 2) && $warn_on_plus);
            ${$rhash}{$key} = $val;
            $tmp = 'Setting '
        }
    }
    prt("[12] $i2: $tmp key [$key], with value [$val] type $lev\n") if ($dbg_s12);
}

sub am_process_AM_file {
    my ($rparams) = @_;
    my $fil = ${$rparams}{'AM_FILE'};
    my $rprogs = ${$rparams}{'REF_PROGRAMS'};
    my $rlibs = ${$rparams}{'REF_LIBRARIES'};
    my $rexit_val = ${$rparams}{'REF_EXIT_VALUE'};

    my ($a_nm, $a_dir) = fileparse($fil);
    $a_dir = $cwd."\\" if ($a_dir =~ /^\.(\\|\/)$/);
    my $sfil = sub_root_folder($fil);
    my %my_hash = ();
    my $refhash = \%my_hash;
    my %targets = ();
    my ($ff);
    my $dooldext = 0;
    if (!open INF, "<$fil") {
        prtw( "WARNING: Unable to open $fil ... $! ...\n" );
        return $refhash;
    }
    my @lns = <INF>;
    close INF;
    my $cnt = scalar @lns;
    prt("\n") if ($dbg_s07 && $dbg_s08);
    prt( "[08] Processing $cnt lines, from [$fil] ...\n" ) if ($dbg_s08);
    my ($i,$line,$fline,$i2,@av,$key,$val,$j,$acnt,$ifcond);
    my ($ind,$len,$tmp,$scnt);
    my @cond_stack = ();
    my $in_target = 0;
    my $target = '';
    $fline = '';
    for ($i = 0; $i < $cnt; $i++) {
        $line = $lns[$i];
        $i2 = $i + 1;
        chomp $line;
        $line = trim_all($line);
        prt("[01] $i2: [$line]\n") if ($dbg_s01);
        next if ($line =~ /^#/);
        $fline .= $line;
        #$len = length($fline);
        #if ($len == 0) {
        #    $in_target = 0;
        #    next;
        #}
        # join continuation lines into one
        if ($fline =~ /\\$/) {
            $fline =~ s/\\$/ /;
            next;
        }
        # deal with the FULL line
        $fline = trim_all($fline);
        $len = length($fline);
        if ($len == 0) {
            $in_target = 0;
            next;
        }
        ${$rparams}{'CURR_LINE'} = $fline;
        ${$rparams}{'CURR_REF_HASH'} = $refhash;
        ${$rparams}{'CURR_LINENUM'} = $i2;
        #$fline = test_for_substitution($fline,$refhash,$i2,$sfil);
        $fline = am_test_for_substitution($rparams);
        if (($fline =~ /$IF_PATTERN/o)||($fline =~ /$IFD_PATTERN/o)) {
            # open an IF
            $ifcond = $1;
            push(@cond_stack, $ifcond . "\@_TRUE\@");
            $scnt = scalar @cond_stack;
            prt( "[06] IF:$scnt: Opened cond_stack with [".$cond_stack[$#cond_stack]."] [$sfil]\n" ) if ($dbg_s06);
            #$in_target = 0;
        } elsif (($fline =~ /$NIF_PATTERN/o)||($fline =~ /$NIF_PATTERN2/o)) {
            # open an IF !(SOMETHING)
            $ifcond = $1;
            push(@cond_stack, $ifcond . "\@_FALSE\@");
            prt( "[06] NIF:$scnt: Opened cond_stack with [".$cond_stack[$#cond_stack]."] [$sfil]\n" ) if ($dbg_s06);
            #$in_target = 0;
        } elsif ($fline =~ /$ELSE_PATTERN/o) {
            # switch to else
            $scnt = scalar @cond_stack;
            if ($scnt) {
                if ($cond_stack[$#cond_stack] =~ /\@_TRUE\@$/) {
                    $cond_stack[$#cond_stack] =~ s/\@_TRUE\@$/\@_FALSE\@/;
                } else {
                    $cond_stack[$#cond_stack] =~ s/\@_FALSE\@$/\@_TRUE\@/;
                }
                prt( "[06] Else:$scnt: Switched cond_stack to [".$cond_stack[$#cond_stack]."] $sfil\n" ) if ($dbg_s06);
            } else {
                prtw( "POTENTIAL ERROR: else without if or nif! [$fil:$i2]\n" );
                ${$rexit_val} = 1;
            }
            #$in_target = 0;
        } elsif ($fline =~ /$ENDIF_PATTERN/o) {
            # reached endif
            if (! @cond_stack) {
                prtw( "ERROR: endif without if! ($sfil:$i2)\n" );
            } else {
                $ifcond = pop (@cond_stack);
                prt( "[06] Closed cond_stack with [$ifcond] $sfil\n" ) if ($dbg_s06);
            }
            #$in_target = 0;
        } elsif ($fline =~ /$INCLUDE_PATTERN/o) {
            $key = $1;
            $ff = $a_dir.$key;
            $ff = fix_rel_path3($ff,'process_AM_file');
            my ($irh,$k,$v,$sff);
            $sff = sub_root_folder($ff);
            if (-f $ff) {
                prt( "[08] Processing INCLUDE file [$ff], from [$fil] ...\n" ) if ($dbg_s08);
                ${$rparams}{'AM_FILE'} = $ff;   # set file to SCAN
                $irh = am_process_AM_file($rparams);
                $v = scalar keys(%{$irh});
                prt( "\n[08] ADVICE: Merging include of $v items from [$sff]...\n") if ($dbg_s08);
                foreach $k (keys %{$irh}) {
                    $v = ${$irh}{$k};
                    if (defined ${$refhash}{$k}) {
                        ${$refhash}{$k} .= ' '.$v;
                    } else {
                        ${$refhash}{$k} = $v;
                    }
                }
                ${$rparams}{'AM_FILE'} = $fil;  # put it BACK
            } else {
                prtw( "ERROR: Unhandled INCLUDE [$key], ($sfil:$i2) [$sff] NOT FOUND\n" );
            }

        } elsif ($fline =~ /^(\w+)\s*=\s*(.*)$/) {
            #$key = $1;
            @av = split('=',$fline);
            $key = trim_all($av[0]);
            $acnt = scalar @av;
            $val = '';  # start with NO VALUE
            # if can be just 'JPEG_SERVER ='
            for ($j = 1; $j < $acnt; $j++) {
                if ($j == 1) {
                    $val = trim_all($av[$j]);
                } else {
                    $val .= '='.trim_all($av[$j]);
                }
            }
            #show_line_split($fline,$key,$val,\@av,$i2);
            if (@cond_stack) {
                $ifcond = $cond_stack[$#cond_stack];
                $key .= ' if '.$ifcond;
            }
            if (length($key) == 0) {
                pgm_exit(1,"ERROR: Split of line [$fline] DID NOT YIELD key! Losing value [$val]\n");
            } else {
                ${$rparams}{'CURR_REF_HASH'} = $refhash;
                ${$rparams}{'CURR_LINENUM'} = $i2;
                ${$rparams}{'CURR_KEY'} = $key;
                ${$rparams}{'CURR_VAL'} = $val;
                #add_key_value_2_hash($key,$val,$refhash,$i2,$sfil,1); # should NOT exist
                add_key_value_2_hash($rparams,1); # should NOT exist
            }
        } elsif ($fline =~ /^(\w+)\s*\+=\s*(.+)$/) {
            $key = $1;
            $val = $2;
            if (@cond_stack) {
                $ifcond = $cond_stack[$#cond_stack];
                $key .= ' if '.$ifcond;
            }
            ${$rparams}{'CURR_REF_HASH'} = $refhash;
            ${$rparams}{'CURR_LINENUM'} = $i2;
            ${$rparams}{'CURR_KEY'} = $key;
            ${$rparams}{'CURR_VAL'} = $val;
            #add_key_value_2_hash($key,$val,$refhash,$i2,$sfil,2); # plus, so key SHOULD exist
            add_key_value_2_hash($rparams,2); # plus, so key SHOULD exist
        } elsif ($fline =~ /^([\.\w-]+)\s*:/) {
            $target = $1;
            $in_target = 1;
            $val = '';
            $ind = index($fline,':');
            if (($ind > 0) && (($ind+1) < $len)) {
                $val = trim_all(substr($fline,($ind+1)));
            }
            if (@cond_stack) {
                $ifcond = $cond_stack[$#cond_stack];
                $target .= ' if '.$ifcond;
            }
            if (defined $targets{$target}) {
                ##prtw( "WARNING: targets[$target] exists with [".$targets{$target}."]! Adding [$val]!! file=$sfil\n" );
                $targets{$target} .= ' '.$val;
                $tmp = 'Added to';
            } else {
                $targets{$target} = $val;
                ##prtw( "WARNING: targets[$target] DOES NOT exist! Adding [$val]!! file=$sfil\n" );
                $tmp = 'Started';
            }
            prt("[11] $i2: $tmp target [$target], with value [$val]\n") if ($dbg_s11);
        } elsif ($fline =~ /^([-\@\w]+)\s*=\s*(.*)$/) {
            $key = $1;
            $val = trim_all($2);
            if (@cond_stack) {
                $ifcond = $cond_stack[$#cond_stack];
                $key .= ' if '.$ifcond;
            }
            if (length($key) == 0) {
                pgm_exit(1,"ERROR: Split of line [$fline] DID NOT YIELD key! Losing value [$val]\n");
            } else {
                ${$rparams}{'CURR_REF_HASH'} = $refhash;
                ${$rparams}{'CURR_LINENUM'} = $i2;
                ${$rparams}{'CURR_KEY'} = $key;
                ${$rparams}{'CURR_VAL'} = $val;
                #add_key_value_2_hash($key,$val,$refhash,$i2,$sfil,1); # should NOT exist
                add_key_value_2_hash($rparams,1); # should NOT exist
            }
        } else {
            if ($in_target && length($target)) {
                if (defined $targets{$target}) {
                    $targets{$target} .= "\n".$fline;
                } else {
                    $targets{$target} = $fline;
                    ##prtw( "WARNING: targets[$target] DOES NOT exist! Adding [$val]!! file=$sfil\n" );
                }
                prt("[11] $i2: Added to targets [$target] value [$fline]\n") if ($dbg_s11);
            } else {
                prt("[01] $i2: [$fline] SKIPPED file=[$fil]\n" ) if ($dbg_s01);
            }
        }
        $fline = '';    # kill this processed line
        $key = '';
        $val = '';
    }

    # done all the LINES, now play with the HASH collected
    $acnt = scalar keys(%{$refhash});
    if ($acnt) {
        #my $rextr = extract_from_hash( $fil, $refhash, $rprogs, $rlibs );
        my $rextr = am_extract_from_hash($rparams);
    } else {
        prt( "NOTE: NO KEYS IN HASH! for [$fil] $cnt lines...\n" );
    }

    # WARN if conditional stack NOT closed
    if (@cond_stack) {
        $val = join("\n",@cond_stack);
        prtw( "WARNING: Items still in cond_stack! [$val]\n file [$fil]\n" );
    }
    return $refhash;
}

# show a SCALAR only reference hash
# that is where all the keys and values are scalar only
sub show_scalar_ref_hash($) {
    my ($rhash) = @_;
    my $cnt = scalar keys(%{$rhash});
    prt("Got $cnt keys for this HASH...\n");
    my ($min,$key,$max,$val,$len);
    $min = 0;
    $max = 40;
    foreach $key (keys %{$rhash}) {
        $len = length($key);
        $min = $len if ($len > $min);
    }
    $min = $max if ($min > $max);
    foreach $key (keys %{$rhash}) {
        $val = ${$rhash}{$key};
        $key .= ' ' while (length($key) < $min);
        prt("$key = [$val]\n");
    }
}

# SUMMARY OUTPUTS
# ===============
#sub list_to_arrays($$$$) {
#    my ($in_fil,$rprogs,$rlibs,$ramsdone) = @_;
sub am_list_to_arrays($) {
    my ($rparams) = @_;
    # extract params
    my $in_fil = ${$rparams}{'AM_FILE'};
    if (! defined $in_fil) {
        prtw("Appears NO Makefile.am files to scan!\n");
        return;
    }
    if ((length($in_fil) == 0)||($in_fil =~ /^\s+$/)) {
        pgm_exit(1,"INTERNAL ERROR: 'AM_FILE' NOT correctly set in rparams!\n");
    }
    my $rprogs = ${$rparams}{'REF_PROGRAMS'};
    my $rlibs = ${$rparams}{'REF_LIBRARIES'};
    # orginal Makefile.am scan hashes, if needed under same keys as above
    my $roph = ${$rparams}{'REF_PROG_HASH'};
    my $rolh = ${$rparams}{'REF_LIBS_HASH'};

    my $ramsdone = ${$rparams}{'REF_AMS_DONE'};
    my $fix_relative_sources = ${$rparams}{'FIX_REL_SOURCE'};
    my $target_dir = ${$rparams}{'TARGET_DIR'};
    my $root_folder = ${$rparams}{'ROOT_FOLDER'};
    my ($in_tit,$in_dir) = fileparse($in_fil);
    my %my_src_hash = ();
    my $rsh = \%my_src_hash;
    my %projects_hash = ();
    my $rph = \%projects_hash;
    my @msvc_c_files = ();
    my @msvc_h_files = ();
    my $am_cnt   = scalar keys(%{$ramsdone});
    my $prog_cnt = scalar keys(%{$rprogs});
    my $libs_cnt = scalar keys(%{$rlibs});
    if (($prog_cnt == 0) && ($libs_cnt == 0)) {
        if ($am_cnt == 1) {
            prt("Processed $am_cnt AM file, but NO programs nor libraries found. [$in_fil]\n");
        } else {
            prt("\nAM files processed yielded NO programs nor libraries! ($am_cnt am files)\n");
        }
        return $rsh;
    }
    my $prog_cnt2 = 0;
    my $lib_cnt2 = 0;
    my $total_sources = 0;
    my $source_missed = 0;
    my $found_count = 0;
    # ====================================================================================
    # This is also the SUMMARY, and check if source found, or NOT
    # set my $total_sources = 0; and my $source_missed = 0;
    my ($key, $val, @av, $fil);
    my ($src, $tit, $dir, $ext, $cnt, $ok, $ff, $rfil);
    my ($ff2,$ok2,@arr);
    my @done = ();
    my $sgrp = get_def_src_grp();    # "Source Files";
    my $sflt = get_def_src_filt();
    my $hgrp = get_def_hdr_grp();    # "Header Files";
    my $hflt = get_def_hdr_filt();
    my $rel_path = '';
    if ($fix_relative_sources) {
        $rel_path = get_rel_dos_path($in_dir,$target_dir);
        prt("Got relative [$rel_path], from in [$in_dir], and targ [$target_dir]\n");
    }
    my ($rhash);    # original HASH of Makefile.am scan
    # process LIBRARIES before PROGRAMS - may use this/these libaries in the programs
    prt("\nAM files yielded the following library SOURCES... (from $am_cnt files)\n") if ($libs_cnt);
    foreach $key (sort keys %{$rlibs}) {
        next if ((length($key) == 0)||($key =~ /^\s+$/));   # ignore BLANKS
        $lib_cnt2++;
        # my $rolh = ${$rparams}{'REF_LIBS_HASH'};
        if (defined ${$rolh}{$key} ) {
            $rhash = ${$rolh}{$key};
            ###show_scalar_ref_hash($rhash);
        } else {
            pgm_exit(1,"INTERNAL ERROR: key [$key] NOT defined in ref HASH! WHY?\n");
        }

        $val = ${$rlibs}{$key};
        @av = split(/\s/,$val);
        $cnt = scalar @av;
        prt("LIBRARY [$key] $cnt SOURCES\n");
        @done = (); # clear DONE
        my %project = ();
        my $rp = \%project;
        my @srcs = ();
        my %dupes = (); # avoid duplications
        ${$rp}{'PROJECT_TYPE'} = 'SL';  # static library
        ${$rp}{'PROJECT_NAME'} = $key;
        # if the $key made it here with macros, then try to adjust the project name
        if ($key =~ /[\@\$]/) {
        }
        foreach $fil (@av) {
            next if ((length($fil) == 0)||($fil =~ /^\s+$/));   # ignore BLANKS
            $ff = $in_dir.$fil;
            $ff = fix_rel_path3($ff,"list_to_arrays");
            next if (-d $ff);   # ignore DIRECTORIES
            $total_sources++;
            if (-f $ff) {
                $ok = "ok";
            } else {
                if (is_c_source_extended($fil)) {
                    $ok = "*** LIB SOURCE NOT FOUND [$ff]";
                } else {
                    $ok = "not found [$ff]";
                }
                if ($find_bad_source) {
                    # do_dir_scan($root_folder,0) if (!$done_dir_scan);
                    @arr = ();
                    ($tit,$dir) = fileparse($fil);
                    $cnt = ac_is_file_in_scan($rparams,$tit,$dir,\@arr);
                    if ($cnt) {
                        $ff = $arr[0];  # for now take just the FIRST, but...
                        $ok = "ok - found $cnt";
                        $found_count++;
                    }
                }
                if (!($ok =~ /^ok/)) {
                    $source_missed++;
                }
            }
            ($tit,$dir) = fileparse($ff);
            if ($fix_relative_sources) {
                $rel_path = get_rel_dos_path($dir,$target_dir);
                $rfil = $rel_path.$tit;
                $ff2 = $target_dir.$rfil;
                if (-f $ff2) {
                    $ok2 = "ok2";
                } else {
                    if ($ok eq 'ok') {
                        $ok2 = "RELATIVE PROBLEM [$ff2]";
                    } else {
                        $ok2 = '';
                    }
                }
                prt( " [15] rel [$rfil] [$fil] $ok $ok2\n" ) if ($dbg_s15);
                $fil = $rfil;
            } else {
                prt( " [15] [$fil] $ok\n" ) if ($dbg_s15);
            }
            if (is_c_source_extended($fil)) {
                if (is_in_array($tit,@done)) {
                    prtw("Duplicate of libs src FILE TITLE [$tit] file [$fil]!\n" ) if ($show_dup_title);
                } else {
                    push(@done,$tit);
                }
                ###push(@msvc_c_files, $src);
                push(@msvc_c_files, [$fil, $sgrp, $sflt]);
            } else {
                ###push(@msvc_h_files, $src);
                push(@msvc_h_files, [$fil, $hgrp, $hflt]);
            }
            if (!defined $dupes{$fil}) {
                $dupes{$fil} = 1;
                push(@srcs,$fil);
            }
        }
        if (@srcs) {
            $cnt = scalar @srcs;
            # prt("Got $cnt sources for [$key]\n");
            ${$rp}{'PROJECT_SOURCES'} = \@srcs;  # console application source
            ${$rph}{$key} = $rp;
        } else {
            prt("Got NO sources for [$key]\n");
        }
    }

    prt( "\nAM files yielded programs $prog_cnt... (from $am_cnt file)\n" ) if ($prog_cnt);
    foreach $key (sort keys %{$rprogs}) {
        next if ((length($key) == 0)||($key =~ /^\s+$/));   # ignore BLANKS
        $prog_cnt2++;
        # my $roph = ${$rparams}{'REF_PROG_HASH'};
        if (defined ${$roph}{$key} ) {
            $rhash = ${$roph}{$key};
            ###show_scalar_ref_hash($rhash);
        } else {
            pgm_exit(1,"INTERNAL ERROR: key [$key] NOT defined in ref HASH! WHY?\n");
        }
        $val = ${$rprogs}{$key}; # get source list
        @av = split(/\s/,$val);
        $cnt = scalar @av;
        prt( "PROGRAM [$key] $cnt SOURCES\n" );
        @done = (); # clear DONE
        my %project = ();
        my $rp = \%project;
        my @srcs = ();
        my %dupes = (); # avoid duplications
        ${$rp}{'PROJECT_TYPE'} = 'CA';  # console application
        ${$rp}{'PROJECT_NAME'} = $key;
        ${$rp}{'PROJECT_USER_LIBS'} = ${$rparams}{'CURR_USER_LIBS'};  # normal fetch for 'libraries'
        foreach $fil (@av) {
            next if ((length($fil) == 0)||($fil =~ /^\s+$/));   # ignore BLANKS
            $ff = $in_dir.$fil;
            $ff = fix_rel_path3($ff,"list_to_arrays");
            next if (-d $ff);   # ignore DIRECTORIES
            $total_sources++;
            if (-f $ff) {
                $ok = "ok";
            } else {
                if (is_c_source_extended($fil)) {
                    $ok = "*** PROG SOURCE NOT FOUND [$ff]";
                } else {
                    $ok = "not found [$ff]";
                }
                if ($find_bad_source) {
                    #do_dir_scan($root_folder,0) if (!$done_dir_scan);
                    @arr = ();
                    ($tit,$dir) = fileparse($fil);
                    $cnt = ac_is_file_in_scan($rparams,$tit,$dir,\@arr);
                    if ($cnt) {
                        $ff = $arr[0];  # for now take just the FIRST, but...
                        $ok = "ok - found $cnt";
                        if (!$fix_relative_sources) {
                            # but have the FULL PATH
                            ($tit,$dir) = fileparse($ff);
                            $rel_path = get_rel_dos_path($dir,$root_folder);
                            $fil = $rel_path.$tit;
                            $fil =~ s/^\.\\//;
                        }
                        $found_count++;
                    }
                }
                if (!($ok =~ /^ok/)) {
                    $source_missed++;
                }
            }
            ($tit,$dir) = fileparse($ff);
            if ($fix_relative_sources) {
                $rel_path = get_rel_dos_path($dir,$target_dir);
                $rfil = $rel_path.$tit;
                $ff2 = $target_dir.$rfil;
                if (-f $ff2) {
                    $ok2 = "ok2";
                } else {
                    if ($ok eq 'ok') {
                        $ok2 = "RELATIVE PROBLEM [$ff2]";
                    } else {
                        $ok2 = '';
                    }
                }
                prt( " [15] rel [$rfil] [$fil] $ok $ok2\n") if ($dbg_s15);
                $fil = $rfil;
            } else {
                prt( " [15] [$fil] $ok\n") if ($dbg_s15);
            }
            if ( is_c_source_extended($fil) ) {
                if ( is_in_array($tit,@done) ) {
                    prtw("Duplicate of prog FILE TITLE [$tit] file [$fil]!\n" ) if ($show_dup_title);
                } else {
                    push(@done,$tit);
                }
                #push(@msvc_c_files, $src);
                push(@msvc_c_files, [$fil, $sgrp, $sflt]);
            } else {
                #push(@msvc_h_files, $src);
                push(@msvc_h_files, [$fil, $hgrp, $hflt]);
            }
            if (!defined $dupes{$fil}) {
                $dupes{$fil} = 1;
                push(@srcs,$fil);
            }
        }
        if (@srcs) {
            $cnt = scalar @srcs;
            # prt("Got $cnt sources for [$key]\n");
            ${$rp}{'PROJECT_SOURCES'} = \@srcs;  # console application source
            ${$rph}{$key} = $rp;
            # see if we need to adjust the dependant libraries
            # this is difficult

        } else {
            prt("Got NO sources for [$key]\n");
        }
    }

    $key = scalar @msvc_c_files;
    $val = scalar @msvc_h_files;
    if ($key || $val || $prog_cnt2 || $lib_cnt2) {
        $ok = "Done AM file [$in_fil], ";
        $ok .= "and ".($am_cnt - 1)." more, " if ($am_cnt > 1);
        $ok .= "and found -";
        prt("$ok\n");
        prt("Set of $key C SOURCE files, and $val headers (and others)...for progs=$prog_cnt2, libs=$lib_cnt2\n" );
    }
    # hmmm, since this is the LAST output, perhaps not a warning
    prt("NOTE: $source_missed of total $total_sources sources were NOT FOUND! [$in_fil]\n") if ($source_missed);
    prt("NOTE: $found_count files were found by a full directory scan of [$in_dir].\n") if ($found_count);

    ${$rsh}{'C_SOURCES'} = [ @msvc_c_files ];
    ${$rsh}{'H_SOURCES'} = [ @msvc_h_files ];

    ${$rparams}{'REF_SOURCES_HASH'} = $rsh;
    ${$rparams}{'REF_PROJECTS_HASH'} = $rph;

    return $rsh;
}

# this is more a DIAGNOSTIC output
# ================================
sub am_out_dir_scan_info($) {
    my ($rparams) = @_;
    return if (! ${$rparams}{'CURR_DONE_SCAN'} );
    my $dir = ${$rparams}{'CURR_FILE_DIR'};
    my $rda = ${$rparams}{'CURR_DIR_SCAN'};
    my $cnt = scalar @{$rda};
    prt("\n");
    prt("[20] Checking $cnt files, from directory scan with those in DSP files... moment...\n") if ($dbg_s20);
    my ($i,$file,$fnd,$done,$sfil,$line);
    my ($missedC, $missedCE, $missedH);
    $done = 0;
    $missedC = 0;
    $missedCE = 0;
    $missedH = 0;
    my @cext = ();
    my @hext = ();
    my %dupes = ();
    for ($i = 0; $i < $cnt; $i++) {
        $sfil = ${$rda}[$i][0];
        $file = ${$rda}[$i][1];  # get FULL FILE
        $fnd = ${$rda}[$i][2];
        if ($fnd) {
            $done++;
        } elsif (is_c_source($sfil)) {
            $missedC++;
            $sfil = sub_root_folder($file);
            prt(" [20] Missed C/C++ [$sfil]\n") if ($dbg_s20);
        } elsif (is_h_source_extended($file)) {
            $missedH++;
            #prt("Missed HEADER extended [$file]\n");
            push(@hext,$file);
        } elsif (is_c_source_extended($sfil)) {
            $missedCE++;
            #prt("Missed C/C++ extended [$file]\n");
            push(@cext,$file);
        }
    }
    prt("DSP files have $done of total $cnt scan, missed $missedC C sources, $missedCE C extended, $missedH HEADER files...\n");
    if ($dbg_s20) {
        foreach $file (@cext) {
            $sfil = sub_root_folder($file);
            prt("Missed C/C++ extended [$sfil]\n");
        }
        if ($missedH) {
            prt("And $missedH HEADERS...\n");
            $line = '';
            foreach $file (@hext) {
                $sfil = sub_root_folder($file);
                if (length($line) && (length("$line $sfil") > 90)) {
                    prt("$line\n");
                    $line = '';
                }
                $line .= "$sfil ";
            }
            prt("$line\n");
            prt("\n") if (length($line));
        }
    } else {
        prt("Would display 'missing' lists, if -d 220 was added to the command.\n\n") if (!$dbg_s20);
    }
}

1;
# eof - lib_amscam.pl
